package com.bizunited.platform.dictionary.service.local.entity;

import com.bizunited.platform.common.entity.UuidOpEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 数据字典导出记录实体
 * @Author: zengxingwang
 * @Date: 2020/5/20 21:16
 */
@Entity
@ApiModel("数据迁移导出记录实体")
@Table(name = "engine_dict_export")
public class DictExportEntity extends UuidOpEntity {

  /**
   * 
   */
  private static final long serialVersionUID = 5955438707468887146L;

  /**
   * 导出数据项，如果没有执行数据项，则表示导出所有数据
   */
  @ApiModelProperty("导出数据项")
  @SaturnColumn(description = "导出数据项")
  @Column(name = "datas", columnDefinition = "varchar(3000) COMMENT '导出数据项'")
  private String datas;

  public String getDatas() {
    return datas;
  }

  public void setDatas(String datas) {
    this.datas = datas;
  }
}
