package com.bizunited.platform.dictionary.service.local.service.internal;

import com.bizunited.platform.core.enums.ImportExecuteModeEnum;
import com.bizunited.platform.core.model.MigrateImportModel;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.dictionary.common.service.dict.DictService;
import com.bizunited.platform.dictionary.common.service.dictItem.DictItemService;
import com.bizunited.platform.dictionary.common.service.dictcategory.DictCategoryService;
import com.bizunited.platform.dictionary.common.vo.DictCategoryVo;
import com.bizunited.platform.dictionary.common.vo.DictItemVo;
import com.bizunited.platform.dictionary.common.vo.DictVo;
import com.bizunited.platform.dictionary.service.local.entity.DictCategoryEntity;
import com.bizunited.platform.dictionary.service.local.entity.DictEntity;
import com.bizunited.platform.dictionary.service.local.entity.DictItemEntity;
import com.bizunited.platform.dictionary.service.local.repository.DictItemRepository;
import com.bizunited.platform.dictionary.service.local.repository.DictRepository;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.transaction.Transactional;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

import static com.bizunited.platform.core.constant.MigrateDataConstants.DICT_FILENAME;
import static javax.transaction.Transactional.TxType.REQUIRES_NEW;

/**
 * DictServiceImpl
 *
 * @description:
 * @author: yanwe
 * @date: 11/Feb/2019 10:33
 */
@Service("dictServiceImpl")
public class DictServiceImpl implements DictService {
  private static final Logger LOGGER = LoggerFactory.getLogger(DictServiceImpl.class);
  private static final String ERROR_CODE_MESS = "鏌ヨ瀛楀吀缂栫爜涓嶈兘涓虹┖锛�";
  private static final String ERROR_MESS = "鏈壘鍒拌缂栫爜鍖归厤瀛楀吀锛�";
  @Autowired 
  private DictRepository dictRepository;
  @Autowired 
  private DictItemRepository dictItemRepository;
  @Autowired 
  private DictCategoryService dictCategoryService;
  @Autowired
  private DictItemService dictItemService;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public List<DictVo> findAll() {
    List<DictEntity> dictEntities = dictRepository.findAll();
    Collection<DictVo> dictVos = this.nebulaToolkitService.copyCollectionByWhiteList(dictEntities, DictEntity.class, DictVo.class, LinkedHashSet.class, ArrayList.class);
    return new ArrayList<>(dictVos);
  }

  @Override
  public List<DictVo> findByStatus(Boolean dictStatus) {
    List<DictEntity> dictEntities = dictRepository.findByDictStatus(dictStatus);
    Collection<DictVo> dictVos = this.nebulaToolkitService.copyCollectionByWhiteList(dictEntities, DictEntity.class, DictVo.class, LinkedHashSet.class, ArrayList.class);
    return new ArrayList<>(dictVos);
  }

  @Override
  public Page<DictVo> findByConditions(
      String dictCode, String dictTitle, String dictType, Boolean dictStatus, Pageable pageable) {
    Map<String, Object> conditions = new HashMap<>();
    if (StringUtils.isNotBlank(dictCode)) {
      conditions.put("dictCode", dictCode);
    }
    if (StringUtils.isNotBlank(dictTitle)) {
      conditions.put("dictTitle", dictTitle);
    }
    if (StringUtils.isNotBlank(dictType)) {
      conditions.put("dictType", dictType);
    }
    // 濡傛灉涓虹┖鍒欓粯璁ゆ煡璇笂鏋剁姸鎬佺殑瀛楀吀
    if (dictStatus != null) {
      conditions.put("dictStatus", dictStatus);
    }

    if (pageable == null) {
      pageable = PageRequest.of(0, 50);
    }
    Page<DictEntity> page = dictRepository.queryPage(pageable, conditions);
    Collection<DictVo> dictVos = this.nebulaToolkitService.copyCollectionByWhiteList(page.getContent(), DictEntity.class, DictVo.class, LinkedHashSet.class, ArrayList.class);
    return new PageImpl<DictVo>(new ArrayList<>(dictVos), page.getPageable(), page.getTotalElements());
  }

  @Override
  public DictVo findDetailsByCodeAndStatus(String dictCode, Boolean showStatus) {
    if(StringUtils.isBlank(dictCode)){
      return null;
    }
    DictEntity entity = dictRepository.findDetailsByCodeAndStatus(dictCode,showStatus);
    if(entity == null){
      return null;
    }
    return this.nebulaToolkitService.copyObjectByWhiteList(entity, DictVo.class, HashSet.class, ArrayList.class, "category", "dictItems");
  }

  @Override
  public Set<DictVo> findDetailsByIds(String[] dictIds) {
    if(dictIds == null || dictIds.length == 0) {
      return Sets.newHashSet();
    }

    Set<DictEntity> dictEntities = this.dictRepository.findDetailsByIds(dictIds);
    Collection<DictVo> dictVos = this.nebulaToolkitService.copyCollectionByWhiteList(dictEntities, DictEntity.class, DictVo.class, LinkedHashSet.class, ArrayList.class, "category" , "dictItems");
    return Sets.newLinkedHashSet(dictVos);
  }

  @Override
  public int countByIds(String[] ids) {
    if(ids == null || ids.length == 0) {
      return 0;
    }
    return this.dictRepository.countByIds(ids);
  }

  @Override
  @Transactional
  public DictVo create(DictVo dictVo, String categoryId) {
    this.validEntity(dictVo, categoryId);
    DictCategoryVo categoryVo = dictCategoryService.findById(categoryId);
    // 鍒ゆ柇CODE鏄惁鏈夐噸澶�
    DictEntity existDict = dictRepository.findByDictCode(dictVo.getDictCode());
    Validate.isTrue(null == existDict, "璇ョ紪鐮佸凡鏈夐噸澶嶏紒");
    DictEntity dictEntity = this.nebulaToolkitService.copyObjectByWhiteList(dictVo, DictEntity.class, HashSet.class, ArrayList.class);

    // 鏂板瀛楀吀榛樿鏄庣粏椤规暟閲忎负0
    dictEntity.setItemNum(0);
    // 榛樿鍚敤鐘舵�佷负true
    dictEntity.setDictStatus(true);
    DictCategoryEntity categoryEntity = this.nebulaToolkitService.copyObjectByWhiteList(categoryVo, DictCategoryEntity.class, HashSet.class, ArrayList.class);
    dictEntity.setCategory(categoryEntity);
    dictEntity.setCreateTime(new Date());
    dictEntity.setModifyTime(new Date());
    DictEntity dict = dictRepository.saveAndFlush(dictEntity);
    //鏂板鏄庣粏椤�
    dictItemService.save(dictEntity.getDictCode(), dictVo.getDictItems());
    return this.nebulaToolkitService.copyObjectByWhiteList(dict, DictVo.class, HashSet.class, ArrayList.class, "dictItems");
  }

  @Override
  public DictVo createByCode(DictVo dictVo, String categoryCode) {
    Validate.notNull(dictVo,"字典信息不能为空");
    Validate.notBlank(categoryCode,"字典分类编号不能为空");
    DictCategoryVo categoryVo = dictCategoryService.findByCode(categoryCode);
    DictEntity existDict = dictRepository.findByDictCode(dictVo.getDictCode());
    Validate.isTrue(null == existDict, "字典编码已存在");
    DictEntity dictEntity = this.nebulaToolkitService.copyObjectByWhiteList(dictVo, DictEntity.class, HashSet.class, ArrayList.class);
    dictEntity.setItemNum(0);
    dictEntity.setDictStatus(true);
    DictCategoryEntity categoryEntity = this.nebulaToolkitService.copyObjectByWhiteList(categoryVo, DictCategoryEntity.class, HashSet.class, ArrayList.class);
    dictEntity.setCategory(categoryEntity);
    dictEntity.setCreateTime(new Date());
    dictEntity.setModifyTime(new Date());
    DictEntity dict = dictRepository.saveAndFlush(dictEntity);
    dictItemService.save(dictEntity.getDictCode(), dictVo.getDictItems());
    return this.nebulaToolkitService.copyObjectByWhiteList(dict, DictVo.class, HashSet.class, ArrayList.class, "dictItems");

  }

  @Override
  @Transactional
  public DictVo update(DictVo dictVo, String categoryId) {
    this.validEntity(dictVo, categoryId);
    DictCategoryVo categoryVo = dictCategoryService.findById(categoryId);
    Validate.notBlank(dictVo.getId(),"鏇存柊鏃讹紝浼犲叆鐨勫瓧鍏竔d涓嶈兘涓虹┖");
    DictEntity existDict = dictRepository.findById(dictVo.getId()).orElse(null);
    Validate.notNull(existDict, "璇ュ瓧鍏镐笉瀛樺湪锛岃妫�鏌ワ紒");
    Validate.isTrue(StringUtils.equals(dictVo.getDictCode(),existDict.getDictCode()),"鏇存柊鏃讹紝瀛楀吀缂栫爜涓嶈兘淇敼");

    existDict.setDescription(dictVo.getDescription());
    existDict.setDictType(dictVo.getDictType());
    existDict.setDictTitle(dictVo.getDictTitle());
    DictCategoryEntity categoryEntity = this.nebulaToolkitService.copyObjectByWhiteList(categoryVo, DictCategoryEntity.class, HashSet.class, ArrayList.class);
    existDict.setCategory(categoryEntity);
    existDict.setModifyTime(new Date());
    existDict.setValueType(dictVo.getValueType());
    //鏇存柊鏄庣粏椤�
    dictItemService.save(existDict.getDictCode(), dictVo.getDictItems());
    existDict.setItemNum(CollectionUtils.isEmpty(dictVo.getDictItems()) ? 0 : dictVo.getDictItems().size());
    DictEntity entity = dictRepository.saveAndFlush(existDict);
    return this.nebulaToolkitService.copyObjectByWhiteList(entity, DictVo.class, HashSet.class, ArrayList.class);
  }

  @Override
  public DictVo updateByCode(DictVo dictVo, String categoryCode) {
    Validate.notNull(dictVo,"字典信息不能为空");
    Validate.notBlank(categoryCode,"字典分类编号不能为空");
    DictCategoryVo categoryVo = dictCategoryService.findByCode(categoryCode);
    DictEntity existDict = dictRepository.findByDictCode(dictVo.getDictCode());
    Validate.notNull(existDict,"修改字段不存在");
    existDict.setDescription(dictVo.getDescription());
    existDict.setDictType(dictVo.getDictType());
    existDict.setDictTitle(dictVo.getDictTitle());
    DictCategoryEntity categoryEntity = this.nebulaToolkitService.copyObjectByWhiteList(categoryVo, DictCategoryEntity.class, HashSet.class, ArrayList.class);
    existDict.setCategory(categoryEntity);
    existDict.setModifyTime(new Date());
    existDict.setValueType(dictVo.getValueType());
    dictItemService.save(existDict.getDictCode(), dictVo.getDictItems());
    existDict.setItemNum(CollectionUtils.isEmpty(dictVo.getDictItems()) ? 0 : dictVo.getDictItems().size());
    DictEntity entity = dictRepository.saveAndFlush(existDict);
    return this.nebulaToolkitService.copyObjectByWhiteList(entity, DictVo.class, HashSet.class, ArrayList.class);

  }

  @Override
  @Transactional
  public DictVo upgrade(String newDictCode, String dictCode) {
    Validate.notBlank(dictCode, ERROR_CODE_MESS);
    DictEntity dictEntity = dictRepository.findByDictCode(dictCode);
    Validate.notNull(dictEntity, ERROR_MESS);
    // 澶嶅埗瀛楀吀
    DictEntity newDict = new DictEntity();
    newDict.setDictCode(newDictCode);
    newDict.setDictTitle(dictEntity.getDictTitle());
    newDict.setItemNum(dictEntity.getItemNum());
    newDict.setDescription(dictEntity.getDescription());
    newDict.setDictType(dictEntity.getDictType());
    newDict.setDictStatus(false);
    newDict.setDictItems(new HashSet<>());
    newDict.setCategory(dictEntity.getCategory());
    newDict.setCreateTime(new Date());
    newDict.setModifyTime(new Date());
    newDict = dictRepository.saveAndFlush(newDict);
    // 澶嶅埗瀛楀吀鏄庣粏
    Set<DictItemEntity> newItems = new HashSet<>();
    for (DictItemEntity item : dictEntity.getDictItems()) {
      DictItemEntity newItem = new DictItemEntity();
      newItem.setDictSort(item.getDictSort());
      newItem.setDictKey(item.getDictKey());
      newItem.setDictValue(item.getDictValue());
      newItem.setDictEntity(newDict);
      newItem.setCreateTime(new Date());
      newItems.add(newItem);
    }
    dictItemRepository.saveAll(newItems);
    return this.nebulaToolkitService.copyObjectByWhiteList(newDict, DictVo.class, HashSet.class, ArrayList.class);
  }

  @Override
  @Transactional
  public DictVo onshelf(String dictCode) {
    Validate.notBlank(dictCode, ERROR_CODE_MESS);
    DictEntity dictEntity = dictRepository.findByDictCode(dictCode);
    Validate.notNull(dictEntity, ERROR_MESS);
    dictEntity.setDictStatus(true);
    DictEntity entity = dictRepository.saveAndFlush(dictEntity);
    return this.nebulaToolkitService.copyObjectByWhiteList(entity, DictVo.class, HashSet.class, ArrayList.class);
  }

  @Override
  @Transactional
  public void delete(String dictCode) {
    Validate.notBlank(dictCode, ERROR_CODE_MESS);
    DictEntity dictEntity = dictRepository.findByDictCode(dictCode);
    Validate.notNull(dictEntity, ERROR_MESS);
    Validate.isTrue(!dictEntity.getDictStatus(), "宸蹭笂鏋剁殑瀛楀吀鏃犳硶鍒犻櫎锛�");
    Set<DictItemEntity> dictItemEntities = dictEntity.getDictItems();
    dictItemRepository.deleteAll(dictItemEntities);
    dictRepository.delete(dictEntity);
  }

  /**
   * 鏍规嵁缂栫爜鏌ヨ
   * @param dictCode
   * @return
   */
  @Override
  public DictVo findByDictCode(String dictCode) {
    if(StringUtils.isBlank(dictCode)){
      return null;
    }
    DictEntity entity = dictRepository.findByDictCode(dictCode);
    if(entity == null) {
      return null;
    }
    return this.nebulaToolkitService.copyObjectByWhiteList(entity, DictVo.class, HashSet.class, ArrayList.class,"category");
  }

  /**
   * 鏍规嵁缂栫爜鏌ヨ锛堝寘鎷叧鑱斾俊鎭級
   * @param dictCode
   * @return
   */
  @Override
  public DictVo findDetailsByDictCode(String dictCode) {
    if(StringUtils.isBlank(dictCode)){
      return null;
    }
    DictEntity entity = dictRepository.findDetailsByDictCode(dictCode);
    if(entity == null) {
      return null;
    }
    return this.nebulaToolkitService.copyObjectByWhiteList(entity, DictVo.class, LinkedHashSet.class, ArrayList.class, "category", "dictItems");
  }

  /**
   * 鎵归噺鏌ヨ锛堝寘鎷叧鑱斾俊鎭級
   * @param dictCodes
   * @return
   */
  @Override
  public Set<DictVo> findDetailsByDictCodes(String[] dictCodes) {
    if(dictCodes == null || dictCodes.length == 0) {
      return null;
    }
    Set<DictEntity> entities = dictRepository.findDetailsByDictCodes(dictCodes);
    Collection<DictVo> dictVos = this.nebulaToolkitService.copyCollectionByWhiteList(entities, DictEntity.class, DictVo.class, HashSet.class, ArrayList.class, "category", "dictItems");
    return Sets.newLinkedHashSet(dictVos);
  }


  /**
   * 楠岃瘉瀹炰綋
   *
   * @param dictVo
   * @param categoryId
   */
  private void validEntity(DictVo dictVo, String categoryId) {
    Validate.notNull(dictVo, "杈撳叆瀛楀吀涓嶅彲涓虹┖!");
    // 鍒ゆ柇璇ュ瓧鍏告槸鍚﹀凡缁忔槸鍚敤鐘舵�侊紝鑻ヤ负鍚敤锛屽垯涓嶅彲鍐嶇紪杈�
    Validate.notBlank(dictVo.getDictCode(), "dict code 涓嶈兘涓虹┖!");
    Validate.notBlank(dictVo.getDictTitle(), "dict title 涓嶈兘涓虹┖!");
    Validate.notBlank(categoryId, "瀛楀吀鍒嗙粍ID涓嶈兘涓虹┖");
    Validate.notBlank(dictVo.getValueType(), "瀛楀吀鍊肩被鍨嬩笉鑳戒负绌�");
    DictCategoryVo categoryVo = dictCategoryService.findById(categoryId);
    Validate.notNull(categoryVo, "鏈煡璇㈠埌瀛楀吀鍒嗙粍");
  }

  /**
   * 鏁版嵁瀛楀吀瀵煎叆鎵ц
   * @param importModel
   */
  @SuppressWarnings("unchecked")
  @Override
  @Transactional(REQUIRES_NEW)
  public void importData(MigrateImportModel importModel) {
    Validate.notNull(importModel, "瀵煎叆淇℃伅涓嶈兘涓虹┖");
    ZipFile zipFile = importModel.getZipFile();
    Validate.notNull(zipFile, "瀵煎叆鏂囦欢涓嶈兘涓虹┖");
    Validate.notNull(importModel.getExecuteMode(), "鎵ц妯″紡涓嶈兘涓虹┖");
    importModel.appendLine("寮�濮嬪鍏ユ暟鎹�");
    ZipEntry dataViewEntry = zipFile.getEntry(DICT_FILENAME);
    if(dataViewEntry == null) {
      importModel.appendLine("瀵煎叆鍘嬬缉鍖呬腑鏈彂鐜版暟鎹枃浠讹紝璇锋鏌�");
    }
    if(dataViewEntry != null) {
      try (InputStream is = zipFile.getInputStream(dataViewEntry);
           ObjectInputStream ois = new ObjectInputStream(is)) {
        List<DictCategoryVo> dictCategorys = (List<DictCategoryVo>) ois.readObject();
        List<DictVo> dicts = (List<DictVo>) ois.readObject();
        if(CollectionUtils.isEmpty(dicts)) {
          importModel.appendLine("瀵煎叆鐨勬暟鎹负绌�");
        } else {
          this.importData(dicts, dictCategorys, importModel);
        }
      } catch (IOException | ClassNotFoundException e) {
        LOGGER.error(e.getMessage(), e);
        importModel.append("璇诲彇涓氬姟鏁版嵁澶辫触锛�").appendLine(e.getMessage());
      }
    }
  }

  /**
   * 瀛楀吀瀵煎叆-鎬绘暟涓庨『搴忓鐞�
   * @param dicts
   * @param dictCategorys
   * @param importModel
   */
  private void importData(List<DictVo> dicts, List<DictCategoryVo> dictCategorys, MigrateImportModel importModel) {
    importModel.setTotalCount(dicts.size());
    Map<String, DictCategoryVo> dictCategoryMap = this.getDictCategoryMapById(dictCategorys);
    for (int i = 0; i < dicts.size(); i++) {
      DictVo dict = dicts.get(i);
      importModel.appendLine(StringUtils.join("--------[", i + 1, "]----------"));
      this.importData(dict, importModel, dictCategoryMap);
    }
  }

  /**
   * 鎶婂瓧鍏哥殑鍒嗙粍瀛樺叆map涓�
   * @param dictCategorys
   * @return
   */
  private Map<String, DictCategoryVo> getDictCategoryMapById(List<DictCategoryVo> dictCategorys) {
    Map<String, DictCategoryVo> dictCategoryMap = new HashMap<>();
    for(DictCategoryVo dictCategoryVo : dictCategorys){
      dictCategoryMap.put(dictCategoryVo.getId(), dictCategoryVo);
    }
    return dictCategoryMap;
  }

  /**
   * 瀵煎叆瀛楀吀-寮�濮嬪鐞嗘暟鎹�
   * @param dict
   * @param importModel
   * @param dictCategoryMap
   */
  private void importData(DictVo dict, MigrateImportModel importModel,  Map<String, DictCategoryVo> dictCategoryMap) {
    importModel.append("寮�濮嬪鐞嗘暟鎹細").appendLine(dict.getDictTitle());
    ImportExecuteModeEnum executeMode = importModel.getExecuteMode();
    DictEntity dbDict = dictRepository.findByDictCode(dict.getDictCode());
    this.handleImportDataId(dict);
    if(dbDict != null && ImportExecuteModeEnum.SKIP == executeMode) {
      importModel.appendLine("鏁版嵁瀛楀吀宸插瓨鍦紝璺宠繃");
      importModel.addSkipCount();
      return;
    }
    if(dbDict != null && ImportExecuteModeEnum.UPDATE == executeMode) {
      importModel.appendLine("鏁版嵁瀛楀吀宸插瓨鍦紝杩涜鏇存柊瑕嗙洊");
      this.handleUpdateData(dict, dbDict, importModel);
      return;
    }
    if(dbDict == null) {
      this.handleCreateData(dict, dbDict, importModel, dictCategoryMap);
      return;
    }
    importModel.appendLine("鏆備笉鏀寔鐨勬墽琛屾柟寮�");
    importModel.addSkipCount();

  }

  /**
   * 瀵煎叆瀛楀吀鐨勬柊澧炲鐞�
   * @param dict
   * @param dbDict
   * @param importModel
   * @param dictCategoryMap
   */
  private void handleCreateData(DictVo dict, DictEntity dbDict, MigrateImportModel importModel, Map<String, DictCategoryVo> dictCategoryMap) {
    importModel.appendLine("寮�濮嬫柊澧炴暟鎹瓧鍏�");
    importModel.appendLine("瀵煎叆鏁版嵁瀛楀吀");
    //澶勭悊鍒嗙被
    String ategoryId = dictCategoryService.importCategory(dict.getCategory().getId(), dictCategoryMap);
    this.create(dict, ategoryId);
    importModel.addCreateCount();
  }

  /**
   * 瀵煎叆瀛楀吀鐨勬洿鏂板鐞�
   * @param dict
   * @param dbDict
   * @param importModel
   */
  private void handleUpdateData(DictVo dict, DictEntity dbDict, MigrateImportModel importModel) {
    DictVo dictVo = nebulaToolkitService.copyObjectByWhiteList(dbDict, DictVo.class, HashSet.class, ArrayList.class);
    dictVo.setDictTitle(dict.getDictTitle());
    dictVo.setDescription(dict.getDescription());
    dictVo.setDictType(dict.getDictType());
    dictVo.setValueType(dict.getValueType());
    dictVo.setDictItems(dict.getDictItems());
    this.update(dictVo, dbDict.getCategory().getId());
    importModel.appendLine("鏇存柊鎴愬姛");
    importModel.addUpdateCount();
  }

  /**
   * 鍘绘帀瀵煎叆鏁版嵁瀛楀吀鍜屽瓧鍏搁」鐨刬d
   * @param dict
   */
  private void handleImportDataId(DictVo dict) {
    dict.setId(null);
    Set<DictItemVo> dictItems = dict.getDictItems();
    if(!CollectionUtils.isEmpty(dictItems)) {
      dictItems.forEach(f -> f.setId(null));
    }
  }

}
