package com.bizunited.platform.rbac2.sdk.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * RBAC模块核心设置?
 * @author yinwenjie
 */
@Component
@ConfigurationProperties(prefix = "rbac")
public class RbacCustomProperties {
  /**
   * 可忽略方法级判定的角色名
   */
  private String[] ignoreMethodCheckRoles;
  /**
   * 配置的那些不允许被删除被作废的角?
   */
  private String[] deleteDenys;
  /**
   * 系统默认的基本角色，基本角色??可以让新创建的用户具备基本的系统功能
   */
  private String baseRoleCode = "BASEROLE";
  
  public String[] getIgnoreMethodCheckRoles() {
    return ignoreMethodCheckRoles;
  }
  public void setIgnoreMethodCheckRoles(String[] ignoreMethodCheckRoles) {
    this.ignoreMethodCheckRoles = ignoreMethodCheckRoles;
  }
  public String[] getDeleteDenys() {
    return deleteDenys;
  }
  public void setDeleteDenys(String[] deleteDenys) {
    this.deleteDenys = deleteDenys;
  }
  public String getBaseRoleCode() {
    return baseRoleCode;
  }
  public void setBaseRoleCode(String baseRoleCode) {
    this.baseRoleCode = baseRoleCode;
  }
}
