package com.bizunited.platform.rbac2.sdk.event;

import com.bizunited.platform.rbac2.sdk.vo.ButtonVo;

/**
 * 功能按钮相关的事件通知
 * @author yinwenjie
 */
public interface ButtonEventListener {
  /**
   * 当新的按钮信息被创建时，该事件被触发。如果该方法抛出异常，那么按钮的创建事件将失败
   * @param competence 新添加的按钮将被返回，但是只返回基本信息
   */
  public void onCreated(ButtonVo button);
  
  /**
   * 当指定按钮被删除时，该事件被触发。
   * @param button 被删除的按钮信息对象(只返回基本信息)
   */
  public void onDeleted(ButtonVo button);
}
