package com.bizunited.platform.rbac2.sdk.event;

import java.util.List;

import com.bizunited.platform.rbac2.sdk.vo.RoleVo;

/**
 * 角色事件监听，凡是需要在角色关键逻辑过程中进行干预的模块，都需要实现该接口</p>
 * 并注入到IOC容器中
 * @author yinwenjie
 *
 */
public interface RoleEventListener {
  /**
   * 实现该接口的，或者说需要借助事件监听和RBAC模块进行依赖集成的业务模块的名字
   * @return
   */
  public String moduleName();
  /**
   * 当角色被创建时，该事件被触发。</br>
   * 如果监听者由于出于业务完整性的考虑，不允许指定角色的创建，则可以直接在实现方法中抛出异常即可
   * @param role
   */
  public void onCreated(RoleVo role);
  /**
   * 当角色被删除时，该事件被触发。</br>
   * 如果监听者由于出于业务完整性的考虑，不允许指定角色的删除，则可以直接在实现方法中抛出异常即可
   * @param role
   */
  public void onDeleted(RoleVo role);
  /**
   * 当RBAC模块根据自身的工作逻辑，需要依赖它的第三方业务模块返回按照指定的角色code，
   * 返回和这个rolecode绑定的或间接绑定的用户账户信息时，该方法会被触发
   * @param roleCode 
   * @param tenantCode 涉及的租户（经销商）信息
   * @return 
   */
  public List<String> onRequestUserAccount(String roleCode , String tenantCode);
}