package com.bizunited.platform.rbac2.sdk.service;

import java.util.List;
import java.util.Set;

import com.bizunited.platform.rbac2.sdk.vo.ButtonVo;

/**
 * 按钮VO的相关服务层接口，主要是各种查询方法</p>
 * <p>注意，按钮VO是不做缓存的，因为实际业务中不会有需要按照独立按钮进行高性能查询的要求</p>
 * @author yinwenjie
 */
public interface ButtonVoService {
  /**
   * 按照按钮技术编号进行指定按钮信息的查询（包括关联信息）
   * @param id
   * @return
   */
  public ButtonVo findById(String id);
  /**
   * 按照按钮的业务编号进行查询
   * @param code
   * @return
   */
  public ButtonVo findByCode(String code);
  /**
   * 查询指定用户的按钮权限，如果当前登录用户有忽略权限的按钮，那就返回所有的权限按钮
   * @param account
   * @return
   */
  public Set<ButtonVo> findByAcconut(String account);
  /**
   * 根据菜单技术编号查询按钮
   * @param topCompetenceId
   * @return 
   */
  public Set<ButtonVo> findByTopCompetenceId(String topCompetenceId);
  /**
   * 按照按钮从属的角色业务编号和菜单技术编号，查询按钮信息
   * @return
   */
  public Set<ButtonVo> findByRoleCodesAndTopCompetenceId(List<String> roleCodes , String topCompetenceId);
}