package com.bizunited.platform.rbac2.sdk.service;

import java.util.Set;

import com.bizunited.platform.rbac2.sdk.vo.CompetenceVo;

/**
 * nebula提供的默认功能SDK服务
 * @author yinwenjie
 */
public interface CompetenceVoService {
  /**
   * 缓存变化订阅的固定键值（注意是都通知，而不是按照租户通知）
   */
  public static final String ALL_COMPETENCE_NOTIFY = "_ALL_COMPETENCE_NOTIFY";
  /**
   * 通知进行功能缓存
   */
  public void notifyCacheRefresh(String appCode);
  /**
   * 清除功能缓存(指定的缓存)
   */
  public void clearCache(String appCode);
  /**
   * 根据指定的角色Name查询已绑定的功能信息，且这些功能状态符合以下查询的要求</br>
   * 1.该接口会对当前传入的角色Code与yml配置的管理员角色Code信息取交集，判定是否具有管理员角色,如果具有管理员权限，则不再受传入角色过滤条件的限制</p>
   * 2.如果当前用户的角色没有包含管理员权限，那么就会查询符合角色要求的所有功能集</br>
   * 注：如果该方法运行后，不返回任何数据，也需要返回一个[]空数组结构</p>
   * 3.查询指定父级功能下，能够被这些角色访问的viewItem为true的，处于正常状态的功能</br>
   * @param viewItem 菜单和功能信息的过滤，可以不传入或传入false，不传入则不做条件过滤限制
   * @param roleCodes 指定的一个或者多个角色code信息（如是：ADMIN、VISTOR）。必须传入一个，否则会直接返回null
   * @param status 状态（1正常/0禁用），这个状态信息不用必须，如果不传入则表示无论功能处于何种状态，都满足查询要求
   */
  public Set<CompetenceVo> findByViewItemAndRoleCodesAndStatus(Boolean viewItem , String tenantCode , String[] roleCodes , Integer status);
  /**
   * 根据显示和状态查询顶级的菜单详情信息，返回的数据包含按钮数据
   * @param viewItem 是否是功能菜单上的功能栏目1：需要显示的；0：不需要显示的（不需传入）
   * @param status 状态信息，1：正常；0：禁用（不一定传入）
   * @param tenantCode 这个tenantCode很有意思，实际上就是将功能和按钮下对应的角色的tenantCode进行一次过滤（不需传入）
   * @return
   */
  public Set<CompetenceVo> findByViewItemAndStatusAndParentNull(Boolean viewItem , String tenantCode , Integer status);
  /**
   * 判定一批角色是否具有指定的resources所代表的URL功能的访问权限。
   * @param resources 一批功能url信息
   * @param tenantCode 这批角色从属的租户信息
   * @param roleCodes 一批角色编号
   * @return 如果匹配，则匹配部分的功能，将进行返回；如果没有任何匹配，将返回null
   */
  public Set<CompetenceVo> findByResources(String[] resources , String tenantCode, String[] roleCodes);
  /**
   * 该方法按照当前登录用户，查询给定的一组URL访问地址中，那些访问地址是可用的。</br>
   * 其本质是按照指定的角色进行查询
   * @param resources 
   * @return
   */
  public Set<CompetenceVo> findByResourcesAndCurrentAccount(String[] resources);
  /**
   * 查询为当前URL设置的功能信息，注意，这里没有通过method进行过滤.
   * @param resource 权限串
   * @param status 状态（正常/禁用）
   */
  public Set<CompetenceVo> findByResource(String resource , Integer status);
  /**
   * 查询为当前URL设置的功能信息，注意，这里没有通过method进行过滤.(模糊查询)
   * @param resource 权限串
   * @param status 状态（正常/禁用）
   */
  public Set<CompetenceVo> findByResourceLike(String resource , Integer status);
  /**
   * 根据资源路径和请求方法查询资源
   * @param resource
   * @param methods
   * @param status 
   * @return
   */
  public CompetenceVo findByResourceAndMethods(String resource, String methods, Integer status);
  /**
   * 根据按钮id查询绑定的接口信息
   * @param buttonCode 按钮业务编号
   * @return
   */
  public Set<CompetenceVo> findByButtonCode(String buttonCode);
  /**
   * 该方法按照一个角色的Id信息，查询能够被这个角色访问的菜单和功能
   * @param tenantCode 可能的租户信息
   * @param roleCodes 角色业务编号
   * @return
   */
  public Set<CompetenceVo> findByRoleCodes(String tenantCode , String[] roleCodes);
  /**
   * 根据多个角色的业务编号查询顶级菜单
   * @param tenantCode 可能的租户信息
   * @param roleCodes 角色业务编号
   * @return
   */
  public Set<CompetenceVo> findByRoleCodesAndParentNull(String tenantCode , String[] roleCodes);
  /**
   * 该方法按照当前登录用户，查询哪些访问地址是可用的。</br>
   * 其本质是按照指定的角色进行查询
   * @param viewItem 是否是功能菜单上的功能栏目1：需要显示的；0：不需要显示的
   * @return
   */
  public Set<CompetenceVo> findByViewItemAndCurrentAccount(Boolean viewItem);
}

