package com.bizunited.platform.rbac2.sdk.vo;

import java.util.Set;

import com.bizunited.platform.common.vo.UuidOpVo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 页面按钮数据持久化描述
 * @Author: Paul Chan yinwenjie
 * @Date: 2021-05-21
 * @version 2.0
 */
@ApiModel(description="页面按钮VO")
public class ButtonVo extends UuidOpVo {
  
  private static final long serialVersionUID = 8166303124606348323L;

  /** 也就是使用按钮的主要功能菜单(code) **/
  @ApiModelProperty("也就是使用按钮的主要功能菜单")
  private String topCompetenceCode;
  
  /** 按钮编码 **/
  @ApiModelProperty("按钮编码")
  private String code;

  /** 按钮名称 */
  @ApiModelProperty("按钮名称")
  private String name;

  /** 按钮说明 */
  @ApiModelProperty("按钮说明")
  private String buttonDesc;

  /** 是否是系统按钮 */
  @ApiModelProperty("是否是系统按钮 ")
  private Boolean system;

  /** 按钮是否有效 */
  @ApiModelProperty("按钮是否有效")
  private Boolean effective;
  
  /** 关联的菜单（可以是多个） */
  @ApiModelProperty("关联的菜单（可以是多个）")
  private Set<String> competenceCodes;
  
  /** 关联的角色，使用“,”分割，每一个角色包括 租户code|角色code */
  @ApiModelProperty("关联的角色（多个）")
  private Set<String> roles;
  
  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getButtonDesc() {
    return buttonDesc;
  }

  public void setButtonDesc(String buttonDesc) {
    this.buttonDesc = buttonDesc;
  }

  public Boolean getSystem() {
    return system;
  }

  public void setSystem(Boolean system) {
    this.system = system;
  }

  public Boolean getEffective() {
    return effective;
  }

  public void setEffective(Boolean effective) {
    this.effective = effective;
  }

  public Set<String> getCompetenceCodes() {
    return competenceCodes;
  }

  public void setCompetenceCodes(Set<String> competenceCodes) {
    this.competenceCodes = competenceCodes;
  }

  public Set<String> getRoles() {
    return roles;
  }

  public String getTopCompetenceCode() {
    return topCompetenceCode;
  }

  public void setTopCompetenceCode(String topCompetenceCode) {
    this.topCompetenceCode = topCompetenceCode;
  }

  public void setRoles(Set<String> roles) {
    this.roles = roles;
  }
}
