package com.bizunited.platform.rbac2.sdk.vo;

import com.bizunited.platform.common.vo.UuidOpVo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Set;

/**
 * 系统功能信息的VO描述
 * @author yinwenjie
 * @version V2.0
 */
@ApiModel("系统功能信息的VO描述")
public class CompetenceVo extends UuidOpVo {
  
  private static final long serialVersionUID = -2036358311649541644L;
  /** 权限URL串. **/
  @ApiModelProperty("权限URL串")
  private String resource = "";
  /** 菜单编码 **/
  @ApiModelProperty("菜单编码")
  private String code = "";
  /** 涉及的方法描述 */
  @ApiModelProperty("涉及的方法描述,例如：POST或者POST|GET|DELETE")
  private String methods = "";
  /** 状态 1正常, 0禁用（枚举）. **/
  @ApiModelProperty("功能状态")
  private Integer tstatus = 1;
  /** 功能备注（功能中文名）. **/
  @ApiModelProperty("功能备注（功能中文名）")
  private String comment = "";
  /** 菜单说明 */
  @ApiModelProperty("菜单说明")
  private String description;
  /** 当前功能项是否显示在菜单树中 */
  @ApiModelProperty("功能项是否显示在菜单树中")
  private Integer viewItem = 0;
  /** 功能排序信息，数字越大排序越靠后 */
  @ApiModelProperty("功能排序信息")
  private Integer sortIndex = 100;
  /** 图表标识信息 */
  @ApiModelProperty("图表标识")
  private String icon = "";
  /** 这个路径是否是带有匹配符的动态路径；1：动态路径；0：非动态路径 */
  @ApiModelProperty("这个路径是否是带有匹配符的动态路径；1：动态路径；0：非动态路径")
  private Integer extractUri = 0;
  /** 接口标签，主要来自swagger api上注解的标签 */
  @ApiModelProperty("接口标签，主要来自swagger api上注解的标签")
  private String tag;
  /** 关联的角色，使用“,”分割，每一个角色包括 经销商_角色code */
  @ApiModelProperty("关联的角色")
  private String roles;
  /** 权限对应的按钮 */
  @ApiModelProperty("权限对应的按钮")
  private Set<ButtonVo> buttons;
  /** 当前功能对应的父级功能，注意可能没有。如果没有父级功能，说明当前这个功能可能就是一个最顶级的父级功能 */
  @ApiModelProperty("当前功能对应的父级功能")
  private CompetenceVo parent;
  /** 菜单下级 */
  @ApiModelProperty("菜单下级")
  private Set<CompetenceVo> children;
  /** 菜单类型 */
  @ApiModelProperty("菜单类型")
  private String type;

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getResource() {
    return resource;
  }
  public void setResource(String resource) {
    this.resource = resource;
  }
  public String getMethods() {
    return methods;
  }
  public void setMethods(String methods) {
    this.methods = methods;
  }

  public Integer getTstatus() {
    return tstatus;
  }
  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }
  public String getComment() {
    return comment;
  }
  public void setComment(String comment) {
    this.comment = comment;
  }
  public Integer getViewItem() {
    return viewItem;
  }
  public void setViewItem(Integer viewItem) {
    this.viewItem = viewItem;
  }
  public Integer getSortIndex() {
    return sortIndex;
  }
  public void setSortIndex(Integer sortIndex) {
    this.sortIndex = sortIndex;
  }
  public String getIcon() {
    return icon;
  }
  public void setIcon(String icon) {
    this.icon = icon;
  }
  public String getTag() {
    return tag;
  }
  public void setTag(String tag) {
    this.tag = tag;
  }
  public Integer getExtractUri() {
    return extractUri;
  }
  public void setExtractUri(Integer extractUri) {
    this.extractUri = extractUri;
  }
  
  public Set<ButtonVo> getButtons() {
    return buttons;
  }

  public void setButtons(Set<ButtonVo> buttons) {
    this.buttons = buttons;
  }

  public CompetenceVo getParent() {
    return parent;
  }
  public void setParent(CompetenceVo parent) {
    this.parent = parent;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public Set<CompetenceVo> getChildren() {
    return children;
  }

  public void setChildren(Set<CompetenceVo> children) {
    this.children = children;
  }

  public String getRoles() {
    return roles;
  }

  public void setRoles(String roles) {
    this.roles = roles;
  }
}
