package com.bizunited.platform.rbac2.sdk.vo;

import com.bizunited.platform.common.vo.TenantOpVo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Map;
import java.util.Set;

/**
 * 博智中间件平台用户角色信息描述
 * @author yinwenjie
 * @version V2.0
 */
@ApiModel(description="角色信息VO")
public class RoleVo extends TenantOpVo {
  
  private static final long serialVersionUID = 6432461588626210634L;

  /** 角色的业务编号. **/
  @ApiModelProperty("角色编码")
  private String roleCode = "";
  /** 角色名称(只能是英文，且保存时必须是大写). **/
  @ApiModelProperty("角色名称")
  private String roleName = "";
  /** 
   * 角色类型编号 
   * T001：业务角色
   * T002：管理角色
   */
  @ApiModelProperty("角色类型编号")
  private String roleType = "";
  /** 状态 1正常, 0禁用(枚举). **/
  @ApiModelProperty("角色状态")
  private Integer tstatus = 1;
  /** 是否系统角色，如果是系统角色就不允许操作者删除 */
  @ApiModelProperty("是否系统角色，如果是系统角色就不允许操作者删除")
  private Boolean isDeny = false;
  /** 该角色默认页面跳转路径 */
  @ApiModelProperty("角色默认页面跳转路径")
  private String defaultUrl;
  /** 备注.角色信息说明，备注信息不用填写，但是至少需要在写操作时传入空字符串 **/
  @ApiModelProperty("备注.角色信息说明，备注信息不用填写，但是至少需要在写操作时传入空字符串")
  private String comment = "";
  /**来源**/
  @ApiModelProperty("来源")
  private String source;
  /** 属于该角色的人员账号信息，其中K，来源于业务模块对RoleEventListener接口的 moduleName()方法的实现,V为userAccount账户集合 */
  @ApiModelProperty("属于该角色的人员账号信息，其中K，来源于业务模块对RoleEventListener接口的 moduleName()方法的实现,V为userAccount账户集合")
  private Map<String , Set<String>> userAccountMaps;
  /** 角色的父级 */
  @ApiModelProperty("角色的父级")
  private RoleVo parent;
  /** 角色的子级 */
  @ApiModelProperty("角色的子级 ")
  private Set<RoleVo> children;
  /** 缓存是否失效，注意被缓存的RoleVo节点的父级节点和子级节点，即使有该属性，也不作为判定依据：true表示已失效 */
  @ApiModelProperty("缓存是否失效，注意被缓存的RoleVo节点的父级节点和子级节点，即使有该属性，也不作为判定依据")
  private volatile boolean cacheInvalid;
  
  public String getRoleCode() {
    return roleCode;
  }
  public void setRoleCode(String roleCode) {
    this.roleCode = roleCode;
  }
  public String getRoleName() {
    return roleName;
  }
  public void setRoleName(String roleName) {
    this.roleName = roleName;
  }
  public String getRoleType() {
    return roleType;
  }
  public void setRoleType(String roleType) {
    this.roleType = roleType;
  }
  public Integer getTstatus() {
    return tstatus;
  }
  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }
  public Boolean getIsDeny() {
    return isDeny;
  }
  public void setIsDeny(Boolean isDeny) {
    this.isDeny = isDeny;
  }
  public String getDefaultUrl() {
    return defaultUrl;
  }
  public void setDefaultUrl(String defaultUrl) {
    this.defaultUrl = defaultUrl;
  }
  public String getComment() {
    return comment;
  }
  public void setComment(String comment) {
    this.comment = comment;
  }
  public String getSource() {
    return source;
  }
  public void setSource(String source) {
    this.source = source;
  }
  public RoleVo getParent() {
    return parent;
  }
  public void setParent(RoleVo parent) {
    this.parent = parent;
  }
  public Set<RoleVo> getChildren() {
    return children;
  }
  public void setChildren(Set<RoleVo> children) {
    this.children = children;
  }
  public Map<String, Set<String>> getUserAccountMaps() {
    return userAccountMaps;
  }
  public void setUserAccountMaps(Map<String, Set<String>> userAccountMaps) {
    this.userAccountMaps = userAccountMaps;
  }
  public boolean isCacheInvalid() {
    return cacheInvalid;
  }
  public void setCacheInvalid(boolean cacheInvalid) {
    this.cacheInvalid = cacheInvalid;
  }
}
