package com.bizunited.platform.rbac2.server.starter.config;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

import com.bizunited.platform.rbac2.sdk.service.ButtonVoService;
import com.bizunited.platform.rbac2.sdk.service.CompetenceVoService;
import com.bizunited.platform.rbac2.sdk.service.RoleVoCacheService;
import com.bizunited.platform.rbac2.sdk.service.RoleVoService;
import com.bizunited.platform.rbac2.server.starter.service.internal.ButtonVoServiceImpl;
import com.bizunited.platform.rbac2.server.starter.service.internal.CompetenceVoServiceImpl;
import com.bizunited.platform.rbac2.server.starter.service.internal.RoleVoCacheServiceImpl;
import com.bizunited.platform.rbac2.server.starter.service.internal.RoleVoServiceImpl;
import com.bizunited.platform.rbac2.server.starter.service.notifier.AuthenticationRbacEventListenerImpl;
import com.bizunited.platform.security.sdk.event.AuthenticationRbacEventListener;

/**
 * nebula 2.4+ 默认的用户模块实现，包括用户、组织机构、岗位和职级四个模块；</br>
 * 按照随后的架构梳理部署，这个模块还要进行拆分
 * @author yinwenjie
 */
@Configuration
@EntityScan(basePackages = "com.bizunited.platform.rbac2.server.starter.entity")
@EnableJpaRepositories(basePackages = "com.bizunited.platform.rbac2.server.starter.repository")
@ComponentScan(basePackages = "com.bizunited.platform.rbac2.server.starter")
public class RbacServerStarterAutoConfiguration {
  @Bean
  @ConditionalOnMissingBean
  public ButtonVoService getButtonVoService() {
    return new ButtonVoServiceImpl();
  }
  
  @Bean
  @ConditionalOnMissingBean
  public CompetenceVoService getCompetenceVoService() {
    return new CompetenceVoServiceImpl();
  }
  
  @Bean
  @ConditionalOnMissingBean
  public RoleVoService getRoleVoService() {
    return new RoleVoServiceImpl();
  }
  
  @Bean
  @ConditionalOnMissingBean
  public RoleVoCacheService getRoleVoCacheService() {
    return new RoleVoCacheServiceImpl();
  }
  
  @Bean
  @ConditionalOnMissingBean
  public AuthenticationRbacEventListener getAuthenticationRbacEventListener() {
    return new AuthenticationRbacEventListenerImpl();
  }
}
