package com.bizunited.platform.rbac2.server.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.rbac2.server.starter.dto.CompetenceConditionDto;
import com.bizunited.platform.rbac2.server.starter.entity.CompetenceEntity;
import com.bizunited.platform.rbac2.server.starter.service.CompetenceService;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 功能服务相关接口.
 * @author yinwenjie
 * @version V1.0
 */
@RestController
@RequestMapping(value="/v1/rbac/competences")
public class CompetenceController extends BaseController {
  private static final Logger LOGGER = LoggerFactory.getLogger(CompetenceController.class);
  @Autowired
  private CompetenceService competenceService;
  
  @ApiOperation(value = "建立指定角色和指定功能的绑定关系")
  @PatchMapping(value = "/bindRole")
  public ResponseModel bindCompetence(@RequestParam(name="roleId") @ApiParam(name = "roleId", value = "指定的角色编号信息") String roleId ,
                                      @RequestParam(name="competenceIds") @ApiParam(name = "competenceIds", value = "指定的功能编号信息(可一个是一个或者多个)") String[] competenceIds) {
    try {
      this.competenceService.bindRole(roleId, competenceIds);
      return this.buildHttpResult();
    } catch(Exception e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  @ApiOperation(value = "对指定角色和指定功能（多个）进行重绑定")
  @PatchMapping(value = "/reBindRole")
  public ResponseModel reBindRole(@RequestParam(name="roleId") @ApiParam(name = "roleId", value = "指定的角色编号信息") String roleId,
                                  @RequestParam(name="competenceIds") @ApiParam(name = "competenceIds", value = "指定的功能编号信息(可一个是一个或者多个)") String[] competenceIds) {
    try {
      this.competenceService.reBindRole(roleId, competenceIds);
      return this.buildHttpResult();
    } catch(Exception e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }
  
  @ApiOperation(value = "取消指定角色和指定功能的绑定关系")
  @PatchMapping(value = "/unbindRole")
  public ResponseModel unbindRole(@RequestParam(name="roleId") @ApiParam(name = "roleId", value = "指定的角色编号信息") String roleId ,
                                        @RequestParam(name="competenceIds") @ApiParam(name = "competenceIds", value = "指定的功能编号信息(可一个是一个或者多个)") String[] competenceIds) {
    try {
      this.competenceService.unbindRole(roleId, competenceIds);
      return this.buildHttpResult();
    } catch(Exception e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }
  
  /**
   * 建立指定按钮和指定接口的绑定关系
   * @param buttonId
   * @param competenceIds
   * @return
   */
  @ApiOperation(value = "建立指定按钮和指定接口的绑定关系")
  @PatchMapping(value = "/bindButton")
  public ResponseModel bindButton(@RequestParam(name = "buttonId") @ApiParam(name = "buttonId", value = "指定的按钮编号信息") String buttonId,
                                   @RequestParam(name = "competenceIds") @ApiParam(name = "competenceIds", value = "指定的接口编号信息(可一个是一个或者多个)") String[] competenceIds) {
    try {
      this.competenceService.bindButtons(buttonId, competenceIds);
      return this.buildHttpResult();
    } catch(Exception e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 取消指定按钮和指定接口的绑定关系
   * @param buttonId
   * @param competenceIds
   * @return
   */
  @ApiOperation(value = "取消指定按钮和指定接口的绑定关系")
  @PatchMapping(value = "/unbindButtons")
  public ResponseModel unbindButtons(@RequestParam(name="buttonId") @ApiParam(name = "buttonId", value = "指定的按钮编号信息") String buttonId ,
                                           @RequestParam(name="competenceIds") @ApiParam(name = "competenceIds", value = "指定的接口编号信息(可一个是一个或者多个)") String[] competenceIds) {
    try {
      this.competenceService.unbindButtons(buttonId, competenceIds);
      return this.buildHttpResult();
    } catch(Exception e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  @ApiOperation(value = "包括很多查询条件的分页查询，这些条件包括但不限于：comment、methods、tstatus、resource")
  @RequestMapping(value = "/findByConditions", method = RequestMethod.GET)
  public ResponseModel findByConditions(CompetenceConditionDto competence, @PageableDefault(value = 50) @ApiParam(name = "pageable", value = "分页参数，当指定page时为查询当前页码（页码从0开始）；当指定size时，为指定每页大小，默认为50") Pageable pageable) {
    try {
      Page<CompetenceEntity> results = this.competenceService.findByConditions(competence, pageable);
      return this.buildHttpResultW(results);
    } catch(Exception e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }
}