package com.bizunited.platform.rbac2.server.starter.entity;

import com.bizunited.platform.common.entity.UuidOpEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import java.util.Set;

/**
 * 页面按钮数据持久化描述
 * @Author: Paul Chan yinwenjie
 * @Date: 2021-05-21
 * @version 2.0
 */
@Entity
@Table(name = "engine_button")
@ApiModel(value = "ButtonEntity" , description="页面按钮数据持久化描述")
public class ButtonEntity extends UuidOpEntity {
  private static final long serialVersionUID = 5188415361499519018L;
  /**
   * 关联的菜单,只能关联viewItem为1的菜单(也就是使用按钮的主要功能菜单)
   */
  @ApiModelProperty("关联的菜单")
  @ManyToOne(fetch = FetchType.LAZY)
  @SaturnColumn(description = "关联的菜单")
  @JoinColumn(name = "competence_id", nullable = false, columnDefinition = "varchar(255) COMMENT '菜单ID'")
  private CompetenceEntity topCompetence;

  /** 按钮编码 **/
  @Column(name = "code", unique = true, nullable = false,  columnDefinition = "varchar(255) COMMENT '按钮编码'")
  @ApiModelProperty(name="code" , value="按钮编码，系统中唯一存在" , required=true)
  @SaturnColumn(description="按钮编码")
  private String code;
  /**
   * 按钮名称
   */
  @Column(name = "name", nullable = false, columnDefinition = "varchar(255) COMMENT '按钮名称'")
  @ApiModelProperty(name="name" , value="按钮名称" , required=true)
  @SaturnColumn(description="按钮名称")
  private String name;
  /**
   * 按钮说明
   */
  @Column(name = "button_desc", columnDefinition = "varchar(255) COMMENT '按钮说明'")
  @ApiModelProperty(name="buttonDesc" , value="按钮说明")
  @SaturnColumn(description="按钮说明")
  private String buttonDesc;
  /**
   * 是否是系统按钮
   */
  @Column(name = "is_system", columnDefinition = "bit(1) COMMENT '是否是系统按钮'")
  @ApiModelProperty(name="system" , value="是否是系统按钮")
  @SaturnColumn(description="是否是系统按钮")
  private Boolean system;
  /**
   * 按钮是否有效
   */
  @Column(name = "effective" , nullable = false, columnDefinition = "tinyint(1) COMMENT '是否有效（ture有效，其他值无效）：如果营销政策设定为无效，则不允许再重新设定为有效'")
  @ApiModelProperty(name="effective" , value="按钮是否有效")
  @SaturnColumn(description="按钮是否有效")
  private Boolean effective;
  /**
   * 关联的接口信息(只是接口viewItem为0,)
   */
  @ApiModelProperty("关联的接口信息(只是接口viewItem为0)")
  @ManyToMany(fetch = FetchType.LAZY)
  @SaturnColumn(description = "关联的接口信息(只是接口viewItem为0)")
  @JoinTable(name = "engine_button_competence_mapping", joinColumns = {@JoinColumn(name = "button_id")}, inverseJoinColumns = {@JoinColumn(name = "competence_id")})
  private Set<CompetenceEntity> competences;
  /**
   * 关联的角色
   */
  @ApiModelProperty("关联的角色")
  @ManyToMany(fetch = FetchType.LAZY, mappedBy = "buttons")
  @SaturnColumn(description = "关联的角色")
  private Set<RoleEntity> roles;

  public CompetenceEntity getTopCompetence() {
    return topCompetence;
  }

  public void setTopCompetence(CompetenceEntity topCompetence) {
    this.topCompetence = topCompetence;
  }

  public Set<RoleEntity> getRoles() {
    return roles;
  }

  public void setRoles(Set<RoleEntity> roles) {
    this.roles = roles;
  }

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getButtonDesc() {
    return buttonDesc;
  }

  public void setButtonDesc(String buttonDesc) {
    this.buttonDesc = buttonDesc;
  }

  public Set<CompetenceEntity> getCompetences() {
    return competences;
  }

  public void setCompetences(Set<CompetenceEntity> competences) {
    this.competences = competences;
  }

  public Boolean getSystem() {
    return system;
  }

  public void setSystem(Boolean system) {
    this.system = system;
  }

  public Boolean getEffective() {
    return effective;
  }

  public void setEffective(Boolean effective) {
    this.effective = effective;
  }

}
