package com.bizunited.platform.rbac2.server.starter.init;

import org.redisson.Redisson;
import org.redisson.api.RTopic;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import com.bizunited.platform.rbac2.sdk.service.CompetenceVoService;
import com.bizunited.platform.rbac2.server.starter.service.notifier.CacheRedisMessageForCompetenceListenerImpl;

/**
 * 在应用程序启动完成后，订阅redis的监听，以便资源桶中任何进程的功能缓存发生变化后
 * 本进程能知晓这个变化，并进行相关处理
 * @author yinwenjie
 */
@Component
public class CacheRedisMessageStartupRunnerForCompetence implements ApplicationListener<ApplicationReadyEvent> {

  @Autowired
  private Redisson redisson;
  @Autowired
  private CacheRedisMessageForCompetenceListenerImpl cacheRedisMessageForCompetenceListener;
  
  @Override
  public void onApplicationEvent(ApplicationReadyEvent event) {
    // 此处是功能模块的redis订阅
    RTopic topicForTenantCompetence = this.redisson.getTopic(CompetenceVoService.ALL_COMPETENCE_NOTIFY);
    topicForTenantCompetence.addListener(String.class, this.cacheRedisMessageForCompetenceListener);
  }
}