package com.bizunited.platform.rbac2.server.starter.init;

import org.redisson.Redisson;
import org.redisson.api.RTopic;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import com.bizunited.platform.rbac2.sdk.service.RoleVoCacheService;
import com.bizunited.platform.rbac2.server.starter.service.notifier.CacheRedisMessageForRoleIdentityListenerImpl;
import com.bizunited.platform.rbac2.server.starter.service.notifier.CacheRedisMessageForRoleListenerImpl;

/**
 * 在应用程序启动完成后，订阅redis的监听，以便资源桶中任何进程的角色缓存发生变化后
 * 本进程能知晓这个变化，并进行相关处理
 * @author yinwenjie
 */
@Component
public class CacheRedisMessageStartupRunnerForRole implements ApplicationListener<ApplicationReadyEvent> {

  @Autowired
  private Redisson redisson;
  @Autowired
  private CacheRedisMessageForRoleListenerImpl cacheRedisMessageForRoleListener;
  @Autowired
  private CacheRedisMessageForRoleIdentityListenerImpl cacheRedisMessageForRoleIdentityListener;
  
  @Override
  public void onApplicationEvent(ApplicationReadyEvent event) {
    // 此处是角色模块的redis订阅-基于tenantCode进行事件通知
    RTopic topicForTenantRole = this.redisson.getTopic(RoleVoCacheService.TENANT_ROLE_NOTIFY);
    topicForTenantRole.addListener(String.class, this.cacheRedisMessageForRoleListener);
    // 此处是角色模块的redis订阅-基于tenantCode + tenantCode进行事件通知
    RTopic topicForTenantIdentityRole = this.redisson.getTopic(RoleVoCacheService.TENANT_ROLE_IDENTITY_NOTIFY);
    topicForTenantIdentityRole.addListener(String.class, this.cacheRedisMessageForRoleIdentityListener);
  }
}