package com.bizunited.platform.rbac2.server.starter.repository;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import com.bizunited.platform.rbac2.server.starter.entity.RoleEntity;
import com.bizunited.platform.rbac2.server.starter.repository.internal.RoleRepositoryCustom;

import java.util.List;
import java.util.Set;

/**
 * @author yinwenjie
 */
@Repository
public interface RoleRepository
    extends
      RoleRepositoryCustom, 
      JpaRepository<RoleEntity, String>,
      JpaSpecificationExecutor<RoleEntity> {
  
  /**
   * 根据角色编码删除
   * @param roleCode
   */
  @Modifying
  @Query(value = "delete from engine_role where tenant_code = :tenantCode and role_code = :roleCode" , nativeQuery = true)
  void deleteByTenantCodeAndRoleCode(@Param("tenantCode") String tenantCode, @Param("roleCode") String roleCode);
  /**
   * 查询符合角色状态的信息
   * @param useStatus
   * @return
   */
  List<RoleEntity> findByTenantCodeAndTstatus(@Param("tenantCode") String tenantCode, @Param("useStatus") Integer useStatus);

  /**
   * 按照填写的角色业务编号与租户信息进行判断
   * @param tenantCode
   * @param roleCode
   * @return
   */
  RoleEntity findByTenantCodeAndRoleCode(String tenantCode, String roleCode);
  /**
   * 按照角色名，查询指定的角色信息
   * @param roleName
   * @return 
   */
  RoleEntity findByTenantCodeAndRoleName(@Param("tenantCode") String tenantCode, @Param("roleName") String roleName);
  /**
   * 查询指定的功能描述所绑定的角色信息
   * @param competenceId 功能描述信息
   * @return 
   */
  @Query("select distinct r from RoleEntity r " +
      " left join fetch r.buttons b " +
      " left join fetch r.competences c " +
      " where c.id = :competenceId ")
  List<RoleEntity> findByCompetenceId(@Param("competenceId") String competenceId);
  
  /**
   * 查询指定按钮所绑定的角色信息
   * @param buttonId 指定的按钮信息
   * @return 
   */
  @Query("select distinct r from RoleEntity r " +
      " left join fetch r.buttons b " +
      " left join fetch r.competences c " +
      " where b.id = :buttonId ")
  List<RoleEntity> findByButtonId(@Param("buttonId") String buttonId);
  
  /**
   * 查询多个角色信息
   * @param ids
   * @return
   */
  @Query("from RoleEntity m where m.id in :ids")
  Set<RoleEntity> findByIds(@Param("ids") List<String> ids);

  /**
   * 查询根角色
   * @return
   */
  Set<RoleEntity> findByTenantCodeAndParentIsNull(@Param("tenantCode") String tenantCode);
  
  /**
   * 查询指定的子级角色节点
   * @param tenantCode 指定的租户编号
   * @param parentId 指定的父级角色技术编号
   * @return
   */
  @Query("from RoleEntity r where r.tenantCode = :tenantCode and r.parent.id = :parentId ")
  Set<RoleEntity> findByTenantCodeAndParent(@Param("tenantCode") String tenantCode , @Param("parentId") String parentId);

  /**
   * 根据多个角色名称查询
   * @param roleNames
   * @return
   */
  @Query("from RoleEntity r where r.tenantCode = :tenantCode and r.roleName in :roleNames ")
  Set<RoleEntity> findByTenantCodeAndRoleNames(@Param("tenantCode") String tenantCode, @Param("roleNames") Set<String> roleNames);

  /**
   * 根据多个角色编码查询
   * @param roleCodes
   * @return
   */
  @Query("from RoleEntity r where r.tenantCode = :tenantCode and r.roleCode in :roleCodes ")
  Set<RoleEntity> findByTenantCodeAndRoleCodes(@Param("tenantCode") String tenantCode, @Param("roleCodes") Set<String> roleCodes);

  /**
   * 根据角色查询详情（不包括子级或者父级节点）
   * @param id
   * @return
   */
  @Query("select distinct r from RoleEntity r " +
      " left join fetch r.competences c " +
      " left join fetch r.buttons b " +
      " where r.id = :id ")
  RoleEntity findDetailsById(@Param("id") String id);
}
