package com.bizunited.platform.rbac2.server.starter.repository.internal;

import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.bizunited.platform.rbac2.server.starter.dto.CompetenceConditionDto;
import com.bizunited.platform.rbac2.server.starter.entity.CompetenceEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Repository
public class CompetenceRepositoryImpl implements CompetenceRepositoryCustom, PageRepositoryImpl {
  @Autowired
  @PersistenceContext
  private EntityManager entityManager;

  private static final String COMMENT = "comment";
  private static final String RESOURCE = "resource";
  private static final String TSTATUS = "tstatus";
  private static final String METHODS = "methods";
  
  @Override
  public Page<CompetenceEntity> findByConditions(Pageable pageable, CompetenceConditionDto competence) {
    /*
     * 目前的查询条件是：名称（模糊）、请求方式、状态
     * */
    StringBuilder hql = new StringBuilder("from CompetenceEntity co where co.viewItem = 0");
    StringBuilder countHql = new StringBuilder("select count(*) from CompetenceEntity co where co.viewItem = 0 ");
    StringBuilder condition = new StringBuilder();
    Map<String, Object> parameter = new HashMap<>();
    parameter.put("projectName", TenantUtils.getTenantCode());
    if(competence != null){
      // 名称
      if(StringUtils.isNotBlank(competence.getComment())) {
        condition.append(" AND co.comment like CONCAT('%', :comment,'%') ");
        parameter.put(COMMENT, competence.getComment());
      }
      //请求方式
      if(StringUtils.isNotBlank(competence.getMethods())) {
        condition.append(" AND co.methods = :methods ");
        parameter.put(METHODS, competence.getMethods());
      }
      //菜单类型
      if(StringUtils.isNotBlank(competence.getResource())) {
        condition.append(" AND co.resource like CONCAT(:resource,'%')  ");
        parameter.put(RESOURCE, competence.getResource());
      }

      //角色状态
      if(competence.getTstatus() != null) {
        condition.append(" AND co.tstatus = :tstatus ");
        parameter.put(TSTATUS, competence.getTstatus());
      }

    }
    hql.append(condition).append(" order by co.sortIndex");
    countHql.append(condition);

    return queryByConditions(entityManager, hql.toString(), countHql.toString(), parameter, pageable, false, null);
  }

  @SuppressWarnings("unchecked")
  @Override
  public List<CompetenceEntity> findAllByConditions(CompetenceConditionDto competence) {
    /*
     * 目前的查询条件是：菜单名称（模糊）、菜单类型、状态
     * */
    StringBuilder hql = new StringBuilder("from CompetenceEntity co where co.viewItem = 1");
    StringBuilder condition = new StringBuilder();
    Map<String, Object> parameter = new HashMap<>();
    condition.append(" AND co.projectName=:projectName ");
    parameter.put("projectName", TenantUtils.getTenantCode());
    if(competence != null){
      // 菜单名称
      if(StringUtils.isNotBlank(competence.getComment())) {
        condition.append(" AND co.comment like CONCAT('%', :comment,'%') ");
        parameter.put(COMMENT, competence.getComment());
      }
      //菜单类型
      if(StringUtils.isNotBlank(competence.getResource())) {
        condition.append(" AND co.resource like CONCAT(:resource,'%')  ");
        parameter.put(RESOURCE, competence.getResource());
      }

      //角色状态
      if(competence.getTstatus() != null) {
        condition.append(" AND co.tstatus = :tstatus ");
        parameter.put(TSTATUS, competence.getTstatus());
      }
    }
    hql.append(condition).append(" order by co.createTime desc");

    Query query = entityManager.createQuery(hql.toString());
    parameter.forEach(query::setParameter);
    return query.getResultList();
  }
}
