package com.bizunited.platform.rbac2.server.starter.repository.internal;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import com.bizunited.platform.rbac2.server.starter.dto.RoleConditionDto;
import com.bizunited.platform.rbac2.server.starter.entity.RoleEntity;

/**
 * 角色持久化自定义接口
 * @Author: yinwenjie
 */
@Repository
public interface RoleRepositoryCustom {

  /**
   * 根据角色名称，或则角色编码，或则角色编码查询角色信息 （角色名称支持模糊查询）
   * @param conditions
   * @param pageable
   * @return
   */
  Page<RoleEntity> findByConditions(RoleConditionDto conditions, Pageable pageable);
}
