package com.bizunited.platform.rbac2.server.starter.repository.internal;

import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.rbac2.server.starter.dto.RoleConditionDto;
import com.bizunited.platform.rbac2.server.starter.entity.RoleEntity;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.util.HashMap;
import java.util.Map;

/**
 * 角色持久化接口实现
 * @Author: yinwenjie
 */
@Repository
public class RoleRepositoryImpl implements RoleRepositoryCustom, PageRepositoryImpl {

  @Autowired
  @PersistenceContext
  private EntityManager entityManager;

  @Override
  public Page<RoleEntity> findByConditions(RoleConditionDto conditions, Pageable pageable) {
    /*
     * 目前的查询条件是：角色名称（模糊）、角色编码、角色状态
     * */
    StringBuilder hql = new StringBuilder("from RoleEntity r where 1 = 1");
    StringBuilder countHql = new StringBuilder("select count(*) from RoleEntity r where 1 = 1 ");
    StringBuilder condition = new StringBuilder();
    Map<String, Object> parameter = new HashMap<>();
    
    if(StringUtils.isNotBlank(conditions.getTenantCode())) {
      condition.append(" AND r.tenantCode = :tenantCode ");
      parameter.put("tenantCode", conditions.getTenantCode());
    }
    // 角色名称
    if(StringUtils.isNotBlank(conditions.getRoleName())) {
      condition.append(" AND r.roleName like CONCAT('%', :roleName, '%') ");
      parameter.put("roleName", conditions.getRoleName());
    }
    //角色编码
    if(StringUtils.isNotBlank(conditions.getRoleCode())) {
      condition.append(" AND r.roleCode = :roleCode ");
      parameter.put("roleCode", conditions.getRoleCode());
    }
    //角色状态
    if(conditions.getStatus() != null) {
      condition.append(" AND r.tstatus = :tstatus ");
      parameter.put("tstatus", conditions.getStatus());
    }
    
    hql.append(condition).append(" order by r.createTime desc");
    countHql.append(condition);
    return this.queryByConditions(entityManager, hql.toString(), countHql.toString(), parameter, pageable, false, null);
  }
}