package com.bizunited.platform.rbac2.server.starter.service;

import com.bizunited.platform.rbac2.server.starter.dto.CompetenceConditionDto;
import com.bizunited.platform.rbac2.server.starter.entity.CompetenceEntity;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 功能服务相关接口.
 * @author yinwenjie
 * @version V1.0
 */
public interface CompetenceService {
  /**
   * 创建新功能，创建新功能是其URL信息必须是唯一的
   * @param comp 权限对象
   * @return CompetenceEntity
   */
  CompetenceEntity create(CompetenceEntity comp);
  /**
   * 批量添加，批量添加当然要进行批量验证
   * @param comps
   * @return
   */
  List<CompetenceEntity> create(List<CompetenceEntity> comps);
  /**
   * 修改功能
   * @param comp 权限对象
   * @return CompetenceEntity
   */
  CompetenceEntity update(CompetenceEntity comp);
  /**
   * 更改功能状态，以便实现功能的启用/禁用功能，注意，一旦父级功能的状态发生变更，那么其所有子级状态（多级）都会发生变化
   * @param id 权限id
   * @param flag 标识（true：启用操作；false：禁用操作）
   * @return 更改后的当前功能的基本信息将被返回
   */
  void updateStatus(String id, Boolean flag);  
  /**
   * 建立指定角色和指定功能的绑定关系
   * @param roleId 指定的角色编号信息
   * @param competenceIds 指定的功能编号信息(可一个是一个或者多个)
   */
  void bindRole(String roleId , String[] competenceIds);
  /**
   * 对指定角色和指定功能（多个）进行重绑定
   * @param roleId 指定的角色编号信息
   * @param competenceIds 指定的功能编号信息(可一个是一个或者多个)
   */
  void reBindRole(String roleId , String[] competenceIds);
  /**
   * 取消指定角色和指定功能的绑定关系
   * @param roleId 指定的角色编号信息
   * @param competenceIds 指定的功能编号信息(可一个是一个或者多个)
   */
  void unbindRole(String roleId , String[] competenceIds);
  /**
   * 建立指定按钮和指定接口的绑定关系
   * @param buttonId
   * @param competenceIds
   */
  void bindButtons(String buttonId, String[] competenceIds);
  /**
   * 取消指定按钮和指定接口的绑定关系
   * @param buttonId
   * @param competenceIds
   */
  void unbindButtons(String buttonId, String[] competenceIds);
  /**
   * 给定一个指定的buttonId，为这个指定的button重新绑定当前这批资源url信息
   * 而无论之前的绑定关系是什么样的
   * @param button
   * @param buttonCompetences
   * @return
   */
  void reBindButtons(String buttonId, String[] competenceIds);
  /**
   * 取消该角色与所有已绑定的功能的绑定关系
   * @param roleId
   */
  void unbindAllRoles(String roleId);
  /**
   * 删除指定的功能，注意：如果当前功能存在下级关联功能，则不能进行删除
   * @param competenceId 指定的功能id
   */
  void deleteById(String competenceId);
  /**
   * 这里只准对功能信息中viewItem为false的信息进行分页查询处理（查询条件也只有功能名）
   * @param competence
   * @return
   */
  Page<CompetenceEntity> findByConditions(CompetenceConditionDto competence, Pageable pageable);
  /**
   * 通过说明、是否显示、父级ID查询资源(查询并不包括关联信息)
   * @param comment
   * @param viewItem
   * @param parentId
   * @return
   */
  public CompetenceEntity findByCommentAndViewItemAndParent(String comment, int viewItem, String parentId);
  /**
   * 通过说明、是否显示，查询顶级功能信息(查询并不包括关联信息)
   * @param comment 
   * @param viewItem 
   * @return
   */
  public CompetenceEntity findByCommentAndViewItemAndParentNull(String comment, int viewItem);
  /**
   * 查询当前系统（可能是资源桶下服务于多个租户的系统）已具有的所有功能信息（无论这些功能可用状态如何）
   * @return 
   */
  public List<CompetenceEntity> findAll();
  /**
   * 根据是否是菜单统计数据
   * @param viewItem
   * @return
   */
  public long countByViewItem(int viewItem);
  /**
   * 统计所有数据
   * @return
   */
  public long count();

}