package com.bizunited.platform.rbac2.server.starter.service;

import java.util.List;
import java.util.Set;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import com.bizunited.platform.rbac2.server.starter.dto.RoleConditionDto;
import com.bizunited.platform.rbac2.server.starter.entity.RoleEntity;

public interface RoleService {
  /**
   * 该方法用于添加一个角色信息，这个角色信息的编号必须是唯一的（租户级别隔离）
   * @param role 新的角色信息
   * @return
   */
  public RoleEntity create(RoleEntity role);
  /**
   * 修改一个指定的角色信息，注意配置在roles.deleteDeny属性的信息不能进行修改操作<br>
   * 且指定的一个角色只能修改角色的comment信息
   * @param role 指定的修改信息
   * @return
   */
  public RoleEntity update(RoleEntity role);
  /**
   * 根据角色编码删除（只有上层系统允许删除时，才能删除）
   * @param roleIds
   */
  public void deleteByIds(String[] roleIds);
  /**
   * 批量重新启用某一个指定的角色信息
   * @param roleIds
   * @return
   */
  public void enable(String[] roleIds);
  /**
   * 批量禁用某一个指定的角色信息（相当于删除）<br>
   * 只是系统中不能真正的删除某一个角色，只能是将这个角色作废掉或者恢复正常状态
   * @param roleIds
   * @return
   */
  public void disable(String[] roleIds);
  
  // ============ 注意，以下查询方式，都是从数据库进行查询
  
  /**
   * 根据ID查询详情
   * @param id
   * @return
   */
  public RoleEntity findDetailsById(String id);
  /**
   * 查询多个角色信息 
   * @param ids 
   * @return
   */
  public Set<RoleEntity> findDetailsByIds(List<String> ids);
  /**
   * 按照角色业务编码和租户信息进行查询
   * @param tenantCode 租户编号（如果不传入，就以默认编号为准）
   * @param roleCode 角色业务编号
   * @return
   */
  public RoleEntity findDetailsByCode(String tenantCode , String roleCode);
  /**
   * 按照角色业务编码和租户信息进行查询
   * @param tenantCode 租户编号（如果不传入，就以默认编号为准）
   * @param roleCodes 角色业务编号，多个
   * @return
   */
  public Set<RoleEntity> findDetailsByCodes(String tenantCode , List<String> roleCodes);
  /**
   * 根据角色名称，或则角色编码，或则角色编码查询角色信息 （角色名称支持模糊查询）
   * ，信息将按照创建时间进行倒序排列
   * @param condition 查询条件，详见源代码和电子文档
   * @param pageable
   * @return
   */
  public Page<RoleEntity> findByConditions(RoleConditionDto condition, Pageable pageable);
}