package com.bizunited.platform.rbac2.server.starter.service.internal;

import java.util.ArrayList;
import java.util.LinkedHashSet;

import javax.transaction.Transactional;

import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;

import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.rbac2.sdk.service.RoleVoService;
import com.bizunited.platform.rbac2.sdk.vo.RoleVo;
import com.bizunited.platform.rbac2.server.starter.entity.RoleEntity;
import com.bizunited.platform.rbac2.server.starter.service.RoleService;

public class RoleVoServiceImpl implements RoleVoService {
  @Autowired
  private RoleService roleService;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;
  
  @Override
  @Transactional
  public RoleVo create(RoleVo roleVo) {
    Validate.notNull(roleVo , "添加操作时，角色描述信息必须填写");
    // 先转换基本信息
    RoleEntity targetRole = nebulaToolkitService.copyObjectByWhiteList(roleVo, RoleEntity.class, LinkedHashSet.class, ArrayList.class);
    // 开始进行正式的添加了
    targetRole = this.roleService.create(targetRole);
    roleVo.setId(targetRole.getId());
    roleVo.setRoleCode(targetRole.getRoleCode());
    return roleVo;
  }

  @Override
  @Transactional
  public RoleVo update(RoleVo roleVo) {
    Validate.notNull(roleVo , "修改操作时，角色描述信息必须填写");
    // 先转换基本信息
    RoleEntity targetRole = nebulaToolkitService.copyObjectByWhiteList(roleVo, RoleEntity.class, LinkedHashSet.class, ArrayList.class);
    // 开始进行正式的添加了
    targetRole = this.roleService.update(targetRole);
    roleVo.setId(targetRole.getId());
    roleVo.setRoleCode(targetRole.getRoleCode());
    return roleVo;
  }
}