package com.bizunited.platform.rbac2.server.starter.service.notifier;

import org.apache.commons.lang3.StringUtils;
import org.redisson.api.listener.MessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.bizunited.platform.rbac2.sdk.service.RoleVoCacheService;

/**
 * 当角色模块收到redis订阅消息，说明当前桶下的某个进程中，已经发生了角色信息的变化
 * 这时需要接受redis的监听消息，以便进行缓存刷新——按照指定tenantCode的变化
 * @author yinwenjie
 */
@Component("CacheRedisMessageForRoleListenerImpl")
public class CacheRedisMessageForRoleListenerImpl implements MessageListener<String> {

  @Autowired
  private RoleVoCacheService roleVoService;
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(CacheRedisMessageForRoleListenerImpl.class);
  
  @Override
  public void onMessage(CharSequence channel, String tenantCode) {
    LOGGER.info("tenant role notifing ......");
    if(!StringUtils.isBlank(tenantCode)) {
      this.roleVoService.clearCache(tenantCode);
    }
  }
}
