package com.bizunited.platform.rbac2.server.starter.service.strategy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import com.bizunited.platform.rbac2.sdk.vo.ButtonVo;
import com.bizunited.platform.rbac2.sdk.vo.CompetenceVo;

/**
 * 针对顶级节点的查询策略，注意，该查询策略只适用于树形查询场景。参见
 * CompetenceVoServiceImpl.recursiveQueryCompetenceForTree(CompetenceQueryStrategy, CompetenceVo)
 * @author yinwenjie
 */
public class QueryByParentNull extends AbstractCompetenceQueryStrategy implements CompetenceQueryStrategy {

  private Boolean viewItem;
  private String tenantCode;
  private Integer status;
  
  /**
   * @param viewItem 一定需要传入
   * @param tenantCode 一定需要传入，查询条件的租户和角色编号组
   * @param status 可以不传入
   */
  public QueryByParentNull(Boolean viewItem,  String tenantCode, Integer status) {
    this.viewItem = viewItem;
    this.tenantCode = tenantCode;
    this.status = status;
  }
  
  @Override
  public CompetenceVo filterCompetence(CompetenceVo competence) {
    /*
     * 处理方式为：只要viewItem、status两个条件都匹配，那么一定返回
     * 注意：tenantCode条件，是复制角色关联信息的是否需要考虑的
     * */
    if(viewItem == null || StringUtils.isBlank(tenantCode))  {
      return null;
    }
    Integer targetViewItem = competence.getViewItem();
    // 注意缓存中roles的格式 tenantcode_roleCode，并以","分割
    String targetRoles = competence.getRoles();
    // 使用viewItem进行过滤
    if(this.viewItem != (targetViewItem == 1?true:false)) {
      return null;
    }
    // 使用status进行过滤
    if(status != null && status != competence.getTstatus().intValue()) {
      return null;
    }
    
    CompetenceVo copyCompetence = this.copyCompetence(competence);
    // 使用tenantCode进行判定，注意，就算没有绑定任何角色，也要进行返回
    String[] matchedRolesReuslt = null;
    if(!StringUtils.isEmpty(targetRoles)) {
      String[] matchedRoles = Arrays.stream(StringUtils.split(targetRoles, ",")).filter(item -> StringUtils.indexOf(item, tenantCode + "|") == 0).toArray(String[]::new);
      // 如果条件成立，说明并没有匹配到任何角色,则不进行返回
      if(matchedRoles == null || matchedRoles.length == 0) {
        copyCompetence.setRoles(null);
      } else {
        matchedRolesReuslt = Arrays.stream(matchedRoles).map(item -> StringUtils.split(item , "|")[1]).toArray(String[]::new);
        copyCompetence.setRoles(StringUtils.join(matchedRolesReuslt , ","));
      }
    } else {
      copyCompetence.setRoles(null);
    }
    
    return copyCompetence;
  }

  @Override
  public ButtonVo filterButton(ButtonVo button) {
    if(viewItem == null || StringUtils.isBlank(tenantCode))  {
      return null;
    }
    // 注意缓存中roles的格式 tenantcode_roleCode，并以","分割
    Set<String> targetRoles = button.getRoles();
    
    ButtonVo copyButton = this.nebulaToolkitService.copyObjectByWhiteList(button, ButtonVo.class, LinkedHashSet.class, ArrayList.class);
    // 使用tenantCode进行判定，注意，就算没有绑定任何角色，也要进行返回
    Set<String> matchedRolesReuslt = null;
    if(!CollectionUtils.isEmpty(targetRoles)) {
      String[] matchedRoles = targetRoles.stream().filter(item -> StringUtils.indexOf(item, tenantCode + "|") == 0).toArray(String[]::new);
      // 如果条件成立，说明并没有匹配到任何角色,则不进行返回
      if(matchedRoles == null || matchedRoles.length == 0) {
        copyButton.setRoles(null);
      } else {
        matchedRolesReuslt = Arrays.stream(matchedRoles).map(item -> StringUtils.split(item , "|")[1]).collect(Collectors.toSet());
        copyButton.setRoles(matchedRolesReuslt);
      }
    } else {
      copyButton.setRoles(null);
    }
    
    return copyButton;
  }
}
