/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac2.server.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.rbac2.server.starter.entity.ButtonEntity;
import com.bizunited.platform.rbac2.server.starter.service.ButtonService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/rbac/buttons"})
public class ButtonController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ButtonController.class);
    @Autowired
    private ButtonService buttonService;

    @PostMapping(value={""})
    @ApiOperation(value="\u521b\u5efa\u6309\u94ae", notes="\u521b\u5efa\u6309\u94ae\uff0c\u5fc5\u987b\u8981\u4f20\u9012\u83dc\u5355\u5bf9\u8c61\uff0c\u5e76\u4e14\u83dc\u5355\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a")
    public ResponseModel create(@ApiParam(value="\u6309\u94ae\u5b9e\u4f53\u4fe1\u606f") @RequestBody ButtonEntity button) {
        try {
            ButtonEntity result = this.buttonService.create(button);
            return this.buildHttpResultW((Object)result, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PostMapping(value={"/batchCreate"})
    @ApiOperation(value="\u6279\u91cf\u521b\u5efa\u6309\u94ae", notes="\u521b\u5efa\u6309\u94ae\uff0c\u5fc5\u987b\u8981\u4f20\u9012\u83dc\u5355\u5bf9\u8c61\uff0c\u5e76\u4e14\u83dc\u5355\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a")
    public ResponseModel batchCreate(@ApiParam(value="\u6309\u94ae\u5b9e\u4f53\u4fe1\u606f") @RequestBody Set<ButtonEntity> buttons) {
        try {
            this.buttonService.batchCreate(buttons);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PatchMapping
    @ApiOperation(value="\u4fee\u6539\u6309\u94ae", notes="\u4fee\u6539\u6309\u94ae")
    public ResponseModel update(@ApiParam(value="\u6309\u94ae\u5b9e\u4f53\u4fe1\u606f") @RequestBody ButtonEntity button) {
        try {
            ButtonEntity result = this.buttonService.update(button);
            return this.buildHttpResultW((Object)result, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @DeleteMapping(value={"batchDelete"})
    @ApiOperation(value="\u6839\u636eid\u6279\u91cf\u5220\u9664\u6309\u94ae")
    public ResponseModel batchDelete(@RequestParam(name="ids") @ApiParam(name="ids", value="\u6307\u5b9a\u7684\u6309\u94aeid\u4fe1\u606f(\u53ef\u4e00\u4e2a\u662f\u4e00\u4e2a\u6216\u8005\u591a\u4e2a)") String[] ids) {
        try {
            this.buttonService.batchDelete(ids);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664\u6309\u94ae", notes="\u6839\u636eid\u5220\u9664\u6309\u94ae")
    public ResponseModel deleteById(@ApiParam(name="id", value="\u6309\u94aeID", required=true) @PathVariable(value="id") String id) {
        try {
            this.buttonService.deleteById(id);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5efa\u7acb\u6307\u5b9a\u89d2\u8272\u548c\u6307\u5b9a\u6309\u94ae\u7684\u7ed1\u5b9a\u5173\u7cfb")
    @PatchMapping(value={"/bindRole"})
    public ResponseModel bindRole(@RequestParam(name="roleId") @ApiParam(name="roleId", value="\u6307\u5b9a\u7684\u89d2\u8272\u7f16\u53f7\u4fe1\u606f") String roleId, @RequestParam(name="buttonIds") @ApiParam(name="buttonIds", value="\u6307\u5b9a\u7684\u6309\u94ae\u7f16\u53f7\u4fe1\u606f(\u53ef\u4e00\u4e2a\u662f\u4e00\u4e2a\u6216\u8005\u591a\u4e2a)") String[] buttonIds) {
        try {
            this.buttonService.bindRole(roleId, buttonIds);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u91cd\u65b0\u5efa\u7acb\u6307\u5b9a\u89d2\u8272\u548c\u6307\u5b9a\u6309\u94ae\u7684\u7ed1\u5b9a\u5173\u7cfb")
    @PatchMapping(value={"/rebindRole"})
    public ResponseModel rebindRole(@RequestParam(name="roleId") @ApiParam(name="roleId", value="\u6307\u5b9a\u7684\u89d2\u8272\u7f16\u53f7\u4fe1\u606f") String roleId, @RequestParam(name="buttonIds") @ApiParam(name="buttonIds", value="\u6307\u5b9a\u7684\u6309\u94ae\u7f16\u53f7\u4fe1\u606f(\u53ef\u4e00\u4e2a\u662f\u4e00\u4e2a\u6216\u8005\u591a\u4e2a)") String[] buttonIds) {
        try {
            this.buttonService.rebindRole(roleId, buttonIds);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u53d6\u6d88\u6307\u5b9a\u89d2\u8272\u548c\u6307\u5b9a\u6309\u94ae\u7684\u7ed1\u5b9a\u5173\u7cfb")
    @PatchMapping(value={"/unbindRole"})
    public ResponseModel unbindRole(@RequestParam(name="roleId") @ApiParam(name="roleId", value="\u6307\u5b9a\u7684\u89d2\u8272\u7f16\u53f7\u4fe1\u606f") String roleId, @RequestParam(name="buttonIds") @ApiParam(name="buttonIds", value="\u6307\u5b9a\u7684\u6309\u94ae\u7f16\u53f7\u4fe1\u606f(\u53ef\u4e00\u4e2a\u662f\u4e00\u4e2a\u6216\u8005\u591a\u4e2a)") String[] buttonIds) {
        try {
            this.buttonService.unbindRole(roleId, buttonIds);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

