/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac2.server.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.rbac2.server.starter.dto.CompetenceConditionDto;
import com.bizunited.platform.rbac2.server.starter.entity.CompetenceEntity;
import com.bizunited.platform.rbac2.server.starter.service.CompetenceService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/rbac/competences"})
public class CompetenceController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompetenceController.class);
    @Autowired
    private CompetenceService competenceService;

    @ApiOperation(value="\u5efa\u7acb\u6307\u5b9a\u89d2\u8272\u548c\u6307\u5b9a\u529f\u80fd\u7684\u7ed1\u5b9a\u5173\u7cfb")
    @PatchMapping(value={"/bindRole"})
    public ResponseModel bindCompetence(@RequestParam(name="roleId") @ApiParam(name="roleId", value="\u6307\u5b9a\u7684\u89d2\u8272\u7f16\u53f7\u4fe1\u606f") String roleId, @RequestParam(name="competenceIds") @ApiParam(name="competenceIds", value="\u6307\u5b9a\u7684\u529f\u80fd\u7f16\u53f7\u4fe1\u606f(\u53ef\u4e00\u4e2a\u662f\u4e00\u4e2a\u6216\u8005\u591a\u4e2a)") String[] competenceIds) {
        try {
            this.competenceService.bindRole(roleId, competenceIds);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5bf9\u6307\u5b9a\u89d2\u8272\u548c\u6307\u5b9a\u529f\u80fd\uff08\u591a\u4e2a\uff09\u8fdb\u884c\u91cd\u7ed1\u5b9a")
    @PatchMapping(value={"/reBindRole"})
    public ResponseModel reBindRole(@RequestParam(name="roleId") @ApiParam(name="roleId", value="\u6307\u5b9a\u7684\u89d2\u8272\u7f16\u53f7\u4fe1\u606f") String roleId, @RequestParam(name="competenceIds") @ApiParam(name="competenceIds", value="\u6307\u5b9a\u7684\u529f\u80fd\u7f16\u53f7\u4fe1\u606f(\u53ef\u4e00\u4e2a\u662f\u4e00\u4e2a\u6216\u8005\u591a\u4e2a)") String[] competenceIds) {
        try {
            this.competenceService.reBindRole(roleId, competenceIds);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u53d6\u6d88\u6307\u5b9a\u89d2\u8272\u548c\u6307\u5b9a\u529f\u80fd\u7684\u7ed1\u5b9a\u5173\u7cfb")
    @PatchMapping(value={"/unbindRole"})
    public ResponseModel unbindRole(@RequestParam(name="roleId") @ApiParam(name="roleId", value="\u6307\u5b9a\u7684\u89d2\u8272\u7f16\u53f7\u4fe1\u606f") String roleId, @RequestParam(name="competenceIds") @ApiParam(name="competenceIds", value="\u6307\u5b9a\u7684\u529f\u80fd\u7f16\u53f7\u4fe1\u606f(\u53ef\u4e00\u4e2a\u662f\u4e00\u4e2a\u6216\u8005\u591a\u4e2a)") String[] competenceIds) {
        try {
            this.competenceService.unbindRole(roleId, competenceIds);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5efa\u7acb\u6307\u5b9a\u6309\u94ae\u548c\u6307\u5b9a\u63a5\u53e3\u7684\u7ed1\u5b9a\u5173\u7cfb")
    @PatchMapping(value={"/bindButton"})
    public ResponseModel bindButton(@RequestParam(name="buttonId") @ApiParam(name="buttonId", value="\u6307\u5b9a\u7684\u6309\u94ae\u7f16\u53f7\u4fe1\u606f") String buttonId, @RequestParam(name="competenceIds") @ApiParam(name="competenceIds", value="\u6307\u5b9a\u7684\u63a5\u53e3\u7f16\u53f7\u4fe1\u606f(\u53ef\u4e00\u4e2a\u662f\u4e00\u4e2a\u6216\u8005\u591a\u4e2a)") String[] competenceIds) {
        try {
            this.competenceService.bindButtons(buttonId, competenceIds);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u53d6\u6d88\u6307\u5b9a\u6309\u94ae\u548c\u6307\u5b9a\u63a5\u53e3\u7684\u7ed1\u5b9a\u5173\u7cfb")
    @PatchMapping(value={"/unbindButtons"})
    public ResponseModel unbindButtons(@RequestParam(name="buttonId") @ApiParam(name="buttonId", value="\u6307\u5b9a\u7684\u6309\u94ae\u7f16\u53f7\u4fe1\u606f") String buttonId, @RequestParam(name="competenceIds") @ApiParam(name="competenceIds", value="\u6307\u5b9a\u7684\u63a5\u53e3\u7f16\u53f7\u4fe1\u606f(\u53ef\u4e00\u4e2a\u662f\u4e00\u4e2a\u6216\u8005\u591a\u4e2a)") String[] competenceIds) {
        try {
            this.competenceService.unbindButtons(buttonId, competenceIds);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5305\u62ec\u5f88\u591a\u67e5\u8be2\u6761\u4ef6\u7684\u5206\u9875\u67e5\u8be2\uff0c\u8fd9\u4e9b\u6761\u4ef6\u5305\u62ec\u4f46\u4e0d\u9650\u4e8e\uff1acomment\u3001methods\u3001tstatus\u3001resource")
    @RequestMapping(value={"/findByConditions"}, method={RequestMethod.GET})
    public ResponseModel findByConditions(CompetenceConditionDto competence, @PageableDefault(value=50) @ApiParam(name="pageable", value="\u5206\u9875\u53c2\u6570\uff0c\u5f53\u6307\u5b9apage\u65f6\u4e3a\u67e5\u8be2\u5f53\u524d\u9875\u7801\uff08\u9875\u7801\u4ece0\u5f00\u59cb\uff09\uff1b\u5f53\u6307\u5b9asize\u65f6\uff0c\u4e3a\u6307\u5b9a\u6bcf\u9875\u5927\u5c0f\uff0c\u9ed8\u8ba4\u4e3a50") Pageable pageable) {
        try {
            Page<CompetenceEntity> results = this.competenceService.findByConditions(competence, pageable);
            return this.buildHttpResultW(results, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

