/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac2.server.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.bizunited.platform.rbac2.server.starter.dto.RoleConditionDto;
import com.bizunited.platform.rbac2.server.starter.entity.RoleEntity;
import com.bizunited.platform.rbac2.server.starter.service.RoleService;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/rbac/roles"})
public class RoleController
extends BaseController {
    @Autowired
    private RoleService roleService;
    private static final Logger LOGGER = LoggerFactory.getLogger(RoleController.class);

    @ApiOperation(value="\u6dfb\u52a0\u4e00\u4e2a\u89d2\u8272\u4fe1\u606f")
    @RequestMapping(value={""}, method={RequestMethod.POST})
    public ResponseModel createRole(@RequestBody @ApiParam(value="role", name="\u65b0\u5efa\u7684\u89d2\u8272\u5bf9\u8c61") RoleEntity role) {
        try {
            if (role == null) {
                throw new IllegalArgumentException("role info not be null!");
            }
            RoleEntity currentRole = this.roleService.create(role);
            return this.buildHttpResultW((Object)currentRole, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u4e00\u4e2a\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f\uff0c\u6ce8\u610f\u914d\u7f6e\u5728roles.sDeny\u5c5e\u6027\u7684\u4fe1\u606f\u4e0d\u80fd\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c\u3002\u4e14\u6307\u5b9a\u7684\u4e00\u4e2a\u89d2\u8272\u53ea\u80fd\u4fee\u6539\u89d2\u8272\u7684comment\u4fe1\u606f")
    @RequestMapping(value={""}, method={RequestMethod.PATCH})
    public ResponseModel updateRole(@RequestBody @ApiParam(value="role", name="\u4fee\u6539\u7684\u89d2\u8272\u5bf9\u8c61") RoleEntity role) {
        try {
            RoleEntity currentRole = this.roleService.update(role);
            return this.buildHttpResultW((Object)currentRole, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u91cd\u65b0\u542f\u7528\u67d0\u4e00\u4e2a\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f")
    @RequestMapping(value={"/enable"}, method={RequestMethod.POST})
    public ResponseModel enableRole(@RequestBody String[] roleIds) {
        try {
            this.roleService.enable(roleIds);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u7981\u7528\u67d0\u4e00\u4e2a\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f\uff08\u76f8\u5f53\u4e8e\u5220\u9664\uff09<br>\u53ea\u662f\u7cfb\u7edf\u4e2d\u4e0d\u80fd\u771f\u6b63\u7684\u5220\u9664\u67d0\u4e00\u4e2a\u89d2\u8272\uff0c\u53ea\u80fd\u662f\u5c06\u8fd9\u4e2a\u89d2\u8272\u4f5c\u5e9f\u6389\u6216\u8005\u6062\u590d\u6b63\u5e38\u72b6\u6001")
    @RequestMapping(value={"/disable"}, method={RequestMethod.POST})
    public ResponseModel disableRole(@RequestBody String[] roleIds) {
        try {
            this.roleService.disable(roleIds);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u89d2\u8272\u6280\u672f\u7f16\u7801\u5220\u9664\uff08\u53ea\u80fd\u5220\u9664\u65e0\u7ed1\u5b9a\u5173\u7cfb\u7684\u89d2\u8272\uff09")
    @PostMapping(value={"/deleteByIds"})
    public ResponseModel deleteByIds(@ApiParam(value="\u89d2\u8272\u7f16\u7801\u6570\u7ec4") @RequestParam(name="roleIds") String[] roleIds) {
        try {
            this.roleService.deleteByIds(roleIds);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u89d2\u8272\u540d\u79f0\uff0c\u6216\u5219\u89d2\u8272\u7f16\u7801\uff0c\u6216\u5219\u89d2\u8272\u7f16\u7801\u67e5\u8be2\u89d2\u8272\u4fe1\u606f \uff08\u89d2\u8272\u540d\u79f0\u652f\u6301\u6a21\u7cca\u67e5\u8be2\uff09")
    @GetMapping(value={"/findByConditions"})
    public ResponseModel findByConditions(@ApiParam(value="\u5206\u9875\u53c2\u6570") @PageableDefault(size=50) Pageable pageable, RoleConditionDto conditions) {
        try {
            Page<RoleEntity> roles = this.roleService.findByConditions(conditions, pageable);
            return this.buildHttpResultW(roles, new String[]{"parent"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"/findDetailsByIds"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u8be6\u60c5\u4fe1\u606f,\u591a\u4e2a\u4fe1\u606f")
    public ResponseModel findDetailsByIds(@RequestParam(name="ids") @ApiParam(value="\u4e3b\u952eID\uff0c\u53ef\u4ee5\u4f20\u5165\u591a\u4e2a") String[] ids) {
        try {
            if (ids == null) {
                return this.buildHttpResult();
            }
            Set<RoleEntity> roles = this.roleService.findDetailsByIds(Lists.newArrayList((Object[])ids));
            return this.buildHttpResultW(roles, new String[]{"parent"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u89d2\u8272\u7f16\u7801\u67e5\u8be2(\u652f\u6301\u591a\u4e2a)")
    @GetMapping(value={"/findByCodes"})
    public ResponseModel findByCode(@ApiParam(value="\u89d2\u8272\u7f16\u7801\u6570\u7ec4") @RequestParam(name="roleCodes") String[] roleCodes) {
        try {
            if (roleCodes == null) {
                return this.buildHttpResult();
            }
            String tenantCode = TenantUtils.getTenantCode();
            Set<RoleEntity> roles = this.roleService.findDetailsByCodes(tenantCode, Lists.newArrayList((Object[])roleCodes));
            return this.buildHttpResultW(roles, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

