/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac2.server.starter.repository;

import com.bizunited.platform.rbac2.server.starter.entity.ButtonEntity;
import java.util.List;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ButtonRepository
extends JpaRepository<ButtonEntity, String>,
JpaSpecificationExecutor<ButtonEntity> {
    @Modifying
    @Query(value="insert into engine_button_competence_mapping(button_id,competence_id) values (:buttonId,:competenceId)", nativeQuery=true)
    public void bindCompetence(@Param(value="buttonId") String var1, @Param(value="competenceId") String var2);

    @Modifying
    @Query(value="delete from engine_button_competence_mapping where button_id = :buttonId and competence_id = :competenceId", nativeQuery=true)
    public void unbindCompetence(@Param(value="buttonId") String var1, @Param(value="competenceId") String var2);

    @Modifying
    @Query(value="delete from engine_button_competence_mapping where button_id = :buttonId", nativeQuery=true)
    public void unbindAllByButtonId(@Param(value="buttonId") String var1);

    @Modifying
    @Query(value="insert into engine_role_button_mapping(role_id,button_id) values (:roleId,:buttonId)", nativeQuery=true)
    public void bindRole(@Param(value="roleId") String var1, @Param(value="buttonId") String var2);

    @Modifying
    @Query(value="delete from engine_role_button_mapping where role_id = :roleId and button_id = :buttonId", nativeQuery=true)
    public void unbindRole(@Param(value="roleId") String var1, @Param(value="buttonId") String var2);

    @Modifying
    @Query(value="delete from engine_role_button_mapping where button_id = :buttonId", nativeQuery=true)
    public void unbindAllRoleByButtonId(@Param(value="buttonId") String var1);

    @Query(value="select count(*) from engine_button_competence_mapping where button_id = :buttonId and competence_id = :competenceId", nativeQuery=true)
    public long countByCompetenceIdAndButtonId(@Param(value="buttonId") String var1, @Param(value="competenceId") String var2);

    @Query(value="select count(b.id) from ButtonEntity b where b.code = :code")
    public long countByCode(@Param(value="code") String var1);

    @Query(value="select count(b.id) from ButtonEntity b where b.code = :code and b.id <> :id")
    public long countByCodeWithoutId(@Param(value="code") String var1, @Param(value="id") String var2);

    @Query(value="select count(*) from engine_role_button_mapping where role_id = :roleId and button_id = :buttonId", nativeQuery=true)
    public long countByRoleIdAndButtonId(@Param(value="roleId") String var1, @Param(value="buttonId") String var2);

    @Query(value="select distinct b from ButtonEntity b  left join fetch b.topCompetence tc  left join fetch b.competences c  left join fetch b.roles r  where b.id = :id order by b.createTime desc ")
    public ButtonEntity findDateilsById(@Param(value="id") String var1);

    @Query(value="select distinct b from ButtonEntity b left join fetch b.roles r where r.id = :roleId  ")
    public Set<ButtonEntity> findByRoleId(@Param(value="roleId") String var1);

    @Query(value="select distinct b from ButtonEntity b  left join fetch b.topCompetence tc  left join fetch b.competences c  left join fetch b.roles r  where b.code = :code ")
    public ButtonEntity findByCode(@Param(value="code") String var1);

    @Query(value="select distinct b from ButtonEntity b  left join fetch b.topCompetence tc  left join fetch b.competences c  left join fetch b.roles r  where tc.id = :topCompetenceId order by b.createTime desc ")
    public Set<ButtonEntity> findByTopCompetenceId(@Param(value="topCompetenceId") String var1);

    @Query(value="select distinct b from ButtonEntity b  left join fetch b.topCompetence tc  left join fetch b.competences c  left join fetch b.roles r  where tc.id in (:topCompetenceIds) order by b.createTime desc ")
    public Set<ButtonEntity> findByTopCompetenceIds(@Param(value="topCompetenceIds") Set<String> var1);

    @Query(value="select distinct b from ButtonEntity b  left join fetch b.topCompetence tc  left join fetch b.competences c  left join fetch b.roles r  where r.roleCode in (:roleCodes) and r.tenantCode = :tenantCode order by b.createTime desc")
    public Set<ButtonEntity> findByRoleCodesAndTenantCode(@Param(value="roleCodes") List<String> var1, @Param(value="tenantCode") String var2);

    @Query(value="select distinct b from ButtonEntity b  left join fetch b.topCompetence tc  left join fetch b.competences c  left join fetch b.roles r  where r.roleCode = :roleCode and tc.id = :topCompetenceId and r.tenantCode = :tenantCode  order by b.createTime desc ")
    public Set<ButtonEntity> findByRoleCodeAndTopCompetenceIdAndTenantCode(@Param(value="roleCode") String var1, @Param(value="topCompetenceId") String var2, @Param(value="tenantCode") String var3);
}

