/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac2.server.starter.service.internal;

import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.bizunited.platform.rbac2.sdk.service.ButtonVoService;
import com.bizunited.platform.rbac2.sdk.service.RoleVoCacheService;
import com.bizunited.platform.rbac2.sdk.vo.ButtonVo;
import com.bizunited.platform.rbac2.sdk.vo.RoleVo;
import com.bizunited.platform.rbac2.server.starter.entity.ButtonEntity;
import com.bizunited.platform.rbac2.server.starter.entity.CompetenceEntity;
import com.bizunited.platform.rbac2.server.starter.entity.RoleEntity;
import com.bizunited.platform.rbac2.server.starter.repository.ButtonRepository;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class ButtonVoServiceImpl
implements ButtonVoService {
    @Autowired
    private RoleVoCacheService roleVoCacheService;
    @Autowired
    private ButtonRepository buttonRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    public ButtonVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ButtonEntity button = this.buttonRepository.findDateilsById(id);
        if (button == null) {
            return null;
        }
        return this.copyButton(button);
    }

    public ButtonVo findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        ButtonEntity button = this.buttonRepository.findByCode(code);
        if (button == null) {
            return null;
        }
        return this.copyButton(button);
    }

    public Set<ButtonVo> findByAcconut(String account) {
        if (StringUtils.isBlank((CharSequence)account)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        Set roles = this.roleVoCacheService.findByTenantCodeAndUserAccount(tenantCode, account);
        if (CollectionUtils.isEmpty((Collection)roles)) {
            return Sets.newHashSet();
        }
        List<String> roleCodes = roles.stream().map(RoleVo::getRoleCode).collect(Collectors.toList());
        Set<ButtonEntity> buttons = this.buttonRepository.findByRoleCodesAndTenantCode(roleCodes, tenantCode);
        if (CollectionUtils.isEmpty(buttons)) {
            return Sets.newHashSet();
        }
        return this.copyButtons(buttons);
    }

    public Set<ButtonVo> findByTopCompetenceId(String topCompetenceId) {
        if (StringUtils.isEmpty((CharSequence)topCompetenceId)) {
            return Sets.newHashSet();
        }
        Set<ButtonEntity> buttons = this.buttonRepository.findByTopCompetenceId(topCompetenceId);
        if (CollectionUtils.isEmpty(buttons)) {
            return Sets.newHashSet();
        }
        return this.copyButtons(buttons);
    }

    public Set<ButtonVo> findByTopCompetenceIds(Set<String> topCompetenceIds) {
        if (CollectionUtils.isEmpty(topCompetenceIds)) {
            return Sets.newHashSet();
        }
        Set<ButtonEntity> buttons = this.buttonRepository.findByTopCompetenceIds(topCompetenceIds);
        if (CollectionUtils.isEmpty(buttons)) {
            return Sets.newHashSet();
        }
        return this.copyButtons(buttons);
    }

    public Set<ButtonVo> findByRoleCodesAndTopCompetenceId(List<String> roleCodes, String topCompetenceId) {
        if (CollectionUtils.isEmpty(roleCodes)) {
            return Sets.newHashSet();
        }
        if (StringUtils.isBlank((CharSequence)topCompetenceId)) {
            return Sets.newHashSet();
        }
        String tenantCode = TenantUtils.getTenantCode();
        Set<ButtonEntity> buttons = this.buttonRepository.findByRoleCodesAndTenantCode(roleCodes, tenantCode);
        if (CollectionUtils.isEmpty(buttons)) {
            return Sets.newHashSet();
        }
        return this.copyButtons(buttons);
    }

    private ButtonVo copyButton(ButtonEntity button) {
        Set<CompetenceEntity> competences;
        CompetenceEntity topCompetence;
        ButtonVo buttonVo = (ButtonVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)button, ButtonVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        Set<RoleEntity> roles = button.getRoles();
        if (!CollectionUtils.isEmpty(roles)) {
            Set roleCodes = roles.stream().map(item -> StringUtils.join((Object[])new String[]{item.getTenantCode(), "|", item.getRoleCode()})).collect(Collectors.toSet());
            buttonVo.setRoles(roleCodes);
        }
        if ((topCompetence = button.getTopCompetence()) != null) {
            buttonVo.setTopCompetenceCode(topCompetence.getCode());
        }
        if (!CollectionUtils.isEmpty(competences = button.getCompetences())) {
            Set competenceCodes = competences.stream().map(CompetenceEntity::getCode).collect(Collectors.toSet());
            buttonVo.setCompetenceCodes(competenceCodes);
        }
        return buttonVo;
    }

    private Set<ButtonVo> copyButtons(Collection<ButtonEntity> buttons) {
        if (CollectionUtils.isEmpty(buttons)) {
            return Sets.newHashSet();
        }
        LinkedHashSet buttonVos = Sets.newLinkedHashSet();
        for (ButtonEntity button : buttons) {
            buttonVos.add(this.copyButton(button));
        }
        return buttonVos;
    }
}

