/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac2.server.starter.service.internal;

import com.bizunited.platform.common.configuration.SimpleTenantProperties;
import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.common.service.CodeGeneratorService;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.bizunited.platform.rbac2.sdk.config.RbacCustomProperties;
import com.bizunited.platform.rbac2.sdk.event.RoleEventListener;
import com.bizunited.platform.rbac2.sdk.service.RoleVoCacheService;
import com.bizunited.platform.rbac2.sdk.vo.RoleVo;
import com.bizunited.platform.rbac2.server.starter.dto.RoleConditionDto;
import com.bizunited.platform.rbac2.server.starter.entity.ButtonEntity;
import com.bizunited.platform.rbac2.server.starter.entity.CompetenceEntity;
import com.bizunited.platform.rbac2.server.starter.entity.RoleEntity;
import com.bizunited.platform.rbac2.server.starter.repository.RoleRepository;
import com.bizunited.platform.rbac2.server.starter.service.ButtonService;
import com.bizunited.platform.rbac2.server.starter.service.CompetenceService;
import com.bizunited.platform.rbac2.server.starter.service.RoleService;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RoleServiceImpl
implements RoleService {
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private RoleVoCacheService roleVoService;
    @Autowired(required=false)
    private List<RoleEventListener> roleEventListeners;
    @Autowired
    private CodeGeneratorService codeGeneratorService;
    @Autowired
    private CompetenceService competenceService;
    @Autowired
    private ButtonService buttonService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RbacCustomProperties rbacCustomProperties;
    @Autowired
    private SimpleTenantProperties simpleTenantProperties;

    @Override
    @Transactional
    public RoleEntity create(RoleEntity role) {
        Set<ButtonEntity> buttons;
        String tenantCode = TenantUtils.getTenantCode();
        if (StringUtils.isBlank((CharSequence)role.getRoleCode())) {
            String code = this.codeGeneratorService.generate(String.format("role:code:index:%s", tenantCode), "JS", null, 1L, 6);
            role.setRoleCode(code);
        }
        role.setTenantCode(tenantCode);
        this.validateRoleBeforeCreate(role);
        this.roleRepository.saveAndFlush((Object)role);
        Set<CompetenceEntity> competences = role.getCompetences();
        if (!CollectionUtils.isEmpty(competences)) {
            String[] competenceIds = (String[])competences.stream().map(UuidEntity::getId).toArray(String[]::new);
            this.competenceService.bindRole(role.getId(), competenceIds);
        }
        if (!CollectionUtils.isEmpty(buttons = role.getButtons())) {
            String[] buttonIds = (String[])buttons.stream().map(UuidEntity::getId).toArray(String[]::new);
            this.buttonService.bindRole(role.getId(), buttonIds);
        }
        if (CollectionUtils.isEmpty(this.roleEventListeners)) {
            RoleVo roleVo = (RoleVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)role, RoleVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            for (RoleEventListener roleEventListener : this.roleEventListeners) {
                roleEventListener.onCreated(roleVo);
            }
        }
        this.roleVoService.notifyCacheRefresh(tenantCode);
        return role;
    }

    private void validateRoleBeforeCreate(RoleEntity role) {
        Authentication authentication;
        Validate.notNull((Object)((Object)role), (String)"\u89d2\u8272\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)role.getRoleName(), (String)"\u89d2\u8272\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)role.getTenantCode(), (String)"\u79df\u6237\u4fe1\u606f/\u7cfb\u7edf\u4fe1\u606f \u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        String roleCode = role.getRoleCode();
        Validate.notBlank((CharSequence)roleCode, (String)"\u6dfb\u52a0\u89d2\u8272\u65f6\uff0c\u89d2\u8272\u4e1a\u52a1\u7f16\u53f7\u5fc5\u987b\u586b\u5199!", (Object[])new Object[0]);
        Validate.isTrue((StringUtils.indexOf((CharSequence)roleCode, (CharSequence)"_") == -1 ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u89d2\u8272\u65f6\uff0c\u89d2\u8272\u4e1a\u52a1\u7f16\u53f7\u4e0d\u5141\u8bb8\u4f7f\u7528\u201c_\u201d\u7b49\u7279\u6b8a\u5b57\u7b26!", (Object[])new Object[0]);
        RoleEntity oldRole = this.roleRepository.findByTenantCodeAndRoleCode(role.getTenantCode(), roleCode);
        Validate.isTrue((oldRole == null ? 1 : 0) != 0, (String)"\u5f53\u524d\u8bbe\u5b9a\u7684\u89d2\u8272\u7f16\u53f7\uff08role code[%s]\uff09\u5df2\u7ecf\u88ab\u4f7f\u7528\uff0c\u8bf7\u66f4\u6362!", (Object[])new Object[]{roleCode});
        Date currentTime = new Date();
        role.setCreateTime(currentTime);
        role.setModifyTime(currentTime);
        if (StringUtils.isBlank((CharSequence)role.getCreateAccount()) && (authentication = SecurityContextHolder.getContext().getAuthentication()) != null) {
            role.setCreateAccount(authentication.getName());
            role.setModifyAccount(authentication.getName());
        }
        Validate.isTrue((StringUtils.isNotBlank((CharSequence)role.getCreateAccount()) && StringUtils.isNotBlank((CharSequence)role.getModifyAccount()) ? 1 : 0) != 0, (String)"\u89d2\u8272\u521b\u5efa\u4eba\u548c\u4fee\u6539\u4eba\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)role.getComment())) {
            role.setComment("[\u672a\u586b\u5199]");
        }
        Validate.isTrue((role.getTstatus() == null || role.getTstatus() == 1 ? 1 : 0) != 0, (String)"\u5f53\u524d\u89d2\u8272\u5fc5\u987b\u662f\u72b6\u6001\u6b63\u5e38\u7684", (Object[])new Object[0]);
        role.setTstatus(1);
        if (role.getParent() != null) {
            Validate.notBlank((CharSequence)role.getParent().getId(), (String)"\u672a\u627e\u5230\u8be5\u89d2\u8272\u7684\u7236\u7ea7\u89d2\u8272\u7684id\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            RoleEntity parentRole = this.roleRepository.findById(role.getParent().getId()).orElse(null);
            Validate.notNull((Object)((Object)parentRole), (String)"\u672a\u627e\u5230\u89d2\u8272\u7684\u7236\u7ea7\u89d2\u8272", (Object[])new Object[0]);
        }
    }

    @Override
    @Transactional
    public RoleEntity update(RoleEntity role) {
        Validate.notNull((Object)((Object)role), (String)"\u89d2\u8272\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String roleId = role.getId();
        String updateComment = role.getComment();
        Validate.notEmpty((CharSequence)roleId, (String)"\u89d2\u8272\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Optional op = this.roleRepository.findById(roleId);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u672a\u627e\u5230\u8be5\u89d2\u8272", (Object[])new Object[0]);
        RoleEntity currentRole = (RoleEntity)((Object)op.get());
        String roleCode = role.getRoleCode();
        Validate.isTrue((!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{roleCode, currentRole.getRoleCode()}) ? 1 : 0) != 0, (String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((StringUtils.indexOf((CharSequence)roleCode, (CharSequence)"_") == -1 ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u89d2\u8272\u65f6\uff0c\u89d2\u8272\u4e1a\u52a1\u7f16\u53f7\u4e0d\u5141\u8bb8\u4f7f\u7528\u201c_\u201d\u7b49\u7279\u6b8a\u5b57\u7b26!", (Object[])new Object[0]);
        String dbRoleCode = currentRole.getRoleCode();
        if (!StringUtils.equals((CharSequence)dbRoleCode, (CharSequence)roleCode)) {
            RoleEntity roleEntity = this.roleRepository.findByTenantCodeAndRoleCode(TenantUtils.getTenantCode(), roleCode);
            Validate.isTrue((roleEntity == null ? 1 : 0) != 0, (String)"\u89d2\u8272\u7f16\u7801\u3010%s\u3011\u5df2\u7ecf\u5b58\u5728", (Object[])new Object[]{roleCode});
        }
        String currentName = currentRole.getRoleName();
        if (this.rbacCustomProperties.getDeleteDenys() != null) {
            for (String deleteDeny : this.rbacCustomProperties.getDeleteDenys()) {
                if (!StringUtils.equals((CharSequence)currentName, (CharSequence)deleteDeny)) continue;
                throw new AccessDeniedException("\u8fd9\u4e2a\u89d2\u8272\u4e3a\u7cfb\u7edf\u7279\u5b9a\u9ed8\u8ba4\u89d2\u8272\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\uff01");
            }
        }
        if (!StringUtils.isBlank((CharSequence)updateComment)) {
            currentRole.setComment(updateComment);
        }
        if (role.getParent() != null) {
            Validate.notBlank((CharSequence)role.getParent().getId(), (String)"\u672a\u627e\u5230\u8be5\u89d2\u8272\u7684\u7236\u7ea7\u89d2\u8272\u7684id\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            RoleEntity parentRole = this.roleRepository.findById(role.getParent().getId()).orElse(null);
            Validate.notNull((Object)((Object)parentRole), (String)"\u672a\u627e\u5230\u89d2\u8272\u7684\u7236\u7ea7\u89d2\u8272", (Object[])new Object[0]);
            Validate.isTrue((!role.getId().equals(parentRole.getId()) ? 1 : 0) != 0, (String)"\u7981\u6b62\u5c06\u8be5\u89d2\u8272\u672c\u8eab\u8bbe\u7f6e\u4e3a\u4e0a\u7ea7\u89d2\u8272", (Object[])new Object[0]);
            currentRole.setParent(parentRole);
            HashSet<String> roleStack = new HashSet<String>();
            roleStack.add(role.getParent().getId());
            this.handleCircular(currentRole, roleStack);
        } else {
            currentRole.setParent(null);
        }
        currentRole.setRoleName(role.getRoleName());
        currentRole.setRoleType(role.getRoleType());
        currentRole.setIsDeny(role.getIsDeny());
        currentRole.setExtend1(role.getExtend1());
        currentRole.setExtend2(role.getExtend2());
        currentRole.setExtend3(role.getExtend3());
        currentRole.setExtend4(role.getExtend4());
        currentRole.setExtend5(role.getExtend5());
        currentRole.setExtend6(role.getExtend6());
        currentRole.setExtend7(role.getExtend7());
        currentRole.setExtend8(role.getExtend8());
        currentRole.setExtend9(role.getExtend9());
        currentRole.setExtend10(role.getExtend10());
        currentRole.setTenantCode(TenantUtils.getTenantCode());
        this.roleRepository.saveAndFlush((Object)currentRole);
        String tenantCode = role.getTenantCode();
        this.roleVoService.notifyCacheRefresh(tenantCode);
        return role;
    }

    private void handleCircular(RoleEntity parent, Set<String> roleStack) {
        if (CollectionUtils.isEmpty(parent.getChildren())) {
            return;
        }
        for (RoleEntity roleEntity : parent.getChildren()) {
            Validate.isTrue((!roleStack.contains(roleEntity.getId()) ? 1 : 0) != 0, (String)"\u5f62\u6210\u5faa\u73af\u4f9d\u8d56\uff0c\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            roleStack.add(roleEntity.getId());
            this.handleCircular(roleEntity, roleStack);
        }
    }

    @Override
    @Transactional
    public void enable(String[] roleIds) {
        Validate.notEmpty((Object[])roleIds, (String)"\u89d2\u8272id\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        HashSet tenantCodes = Sets.newHashSet();
        for (String roleId : roleIds) {
            RoleEntity currentRole = this.roleRepository.findById(roleId).orElse(null);
            Validate.notNull((Object)((Object)currentRole), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.isTrue((currentRole.getIsDeny() == false ? 1 : 0) != 0, (String)"\u89d2\u8272\u3010%s\u3011\u7cfb\u7edf\u89d2\u8272\u4e0d\u5141\u8bb8\u542f\u7528\u7981\u7528", (Object[])new Object[]{currentRole.getRoleName()});
            currentRole.setTstatus(1);
            this.roleRepository.save((Object)currentRole);
            tenantCodes.add(currentRole.getTenantCode());
        }
        for (String tenantCode : tenantCodes) {
            this.roleVoService.notifyCacheRefresh(tenantCode);
        }
    }

    @Override
    @Transactional
    public void disable(String[] roleIds) {
        Validate.notEmpty((Object[])roleIds, (String)"\u89d2\u8272id\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        HashSet tenantCodes = Sets.newHashSet();
        for (String roleId : roleIds) {
            RoleEntity currentRole = this.roleRepository.findById(roleId).orElse(null);
            Validate.notNull((Object)((Object)currentRole), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.isTrue((currentRole.getIsDeny() == false ? 1 : 0) != 0, (String)"\u89d2\u8272\u3010%s\u3011\u7cfb\u7edf\u89d2\u8272\u4e0d\u5141\u8bb8\u542f\u7528\u7981\u7528", (Object[])new Object[]{currentRole.getRoleName()});
            if (this.rbacCustomProperties.getDeleteDenys() != null && StringUtils.equalsAny((CharSequence)currentRole.getRoleCode(), (CharSequence[])this.rbacCustomProperties.getDeleteDenys())) {
                throw new AccessDeniedException("\u81f3\u5c11\u6709\u4e00\u4e2a\u89d2\u8272\u88ab\u4e0d\u80fd\u7981\u7528\uff01");
            }
            tenantCodes.add(currentRole.getTenantCode());
            currentRole.setTstatus(0);
            this.roleRepository.save((Object)currentRole);
        }
        for (String tenantCode : tenantCodes) {
            this.roleVoService.notifyCacheRefresh(tenantCode);
        }
    }

    @Override
    @Transactional
    public void deleteByIds(String[] roleIds) {
        Validate.notEmpty((Object[])roleIds, (String)"\u5220\u9664\u65f6\uff0c\u81f3\u5c11\u6709\u4e00\u4e2a\u89d2\u8272\u7f16\u7801", (Object[])new Object[0]);
        HashSet tenantCodes = Sets.newHashSet();
        for (String roleId : roleIds) {
            RoleEntity roleEntity = this.roleRepository.findById(roleId).orElse(null);
            Validate.notNull((Object)((Object)roleEntity), (String)"\u81f3\u5c11\u6709\u4e00\u4e2a\u89d2\u8272\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5220\u9664", (Object[])new Object[0]);
            if (!CollectionUtils.isEmpty(this.roleEventListeners)) {
                RoleVo roleVo = (RoleVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)roleEntity, RoleVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                for (RoleEventListener roleEventListener : this.roleEventListeners) {
                    roleEventListener.onDeleted(roleVo);
                }
            }
            tenantCodes.add(roleEntity.getTenantCode());
            Set<CompetenceEntity> competences = roleEntity.getCompetences();
            Validate.isTrue((!CollectionUtils.isEmpty(competences) ? 1 : 0) != 0, (String)"\u5f53\u524d\u89d2\u8272\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u83dc\u5355/\u529f\u80fd\uff0c\u4e0d\u80fd\u8fdb\u884c\u5220\u9664", (Object[])new Object[0]);
            Set<ButtonEntity> buttons = roleEntity.getButtons();
            Validate.isTrue((!CollectionUtils.isEmpty(buttons) ? 1 : 0) != 0, (String)"\u5f53\u524d\u89d2\u8272\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u6309\u94ae\uff0c\u4e0d\u80fd\u8fdb\u884c\u5220\u9664", (Object[])new Object[0]);
            this.roleRepository.deleteById(roleId);
        }
        for (String tenantCode : tenantCodes) {
            this.roleVoService.notifyCacheRefresh(tenantCode);
        }
    }

    @Override
    public RoleEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        RoleEntity role = this.roleRepository.findDetailsById(id);
        if (role == null) {
            return null;
        }
        return this.buildCopyRole(role);
    }

    @Override
    public Set<RoleEntity> findDetailsByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        Set<RoleEntity> resutls = this.roleRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(resutls)) {
            return null;
        }
        LinkedHashSet targetResutls = Sets.newLinkedHashSet();
        for (RoleEntity role : resutls) {
            targetResutls.add(this.buildCopyRole(role));
        }
        return targetResutls;
    }

    @Override
    public RoleEntity findDetailsByCode(String tenantCode, String roleCode) {
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            tenantCode = this.simpleTenantProperties.getDefaultTenantCode();
        }
        RoleEntity roleEntity = this.roleRepository.findByTenantCodeAndRoleCode(tenantCode, roleCode);
        return this.buildCopyRole(roleEntity);
    }

    @Override
    public Set<RoleEntity> findDetailsByCodes(String tenantCode, List<String> roleCodes) {
        if (CollectionUtils.isEmpty(roleCodes)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            tenantCode = this.simpleTenantProperties.getDefaultTenantCode();
        }
        Set<RoleEntity> resutls = this.roleRepository.findByTenantCodeAndRoleCodes(tenantCode, Sets.newLinkedHashSet(roleCodes));
        LinkedHashSet targetResutls = Sets.newLinkedHashSet();
        for (RoleEntity role : resutls) {
            targetResutls.add(this.buildCopyRole(role));
        }
        return targetResutls;
    }

    @Override
    public Page<RoleEntity> findByConditions(RoleConditionDto conditions, Pageable pageable) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)20);
        }
        if (conditions == null) {
            conditions = new RoleConditionDto();
        }
        conditions.setTenantCode(TenantUtils.getTenantCode());
        Page<RoleEntity> results = this.roleRepository.findByConditions(conditions, pageable);
        if (results == null || CollectionUtils.isEmpty((Collection)results.getContent())) {
            return null;
        }
        List contents = results.getContent();
        ArrayList targetContents = Lists.newArrayList();
        for (RoleEntity content : contents) {
            RoleEntity targetContent = this.buildCopyRole(content);
            targetContents.add(targetContent);
        }
        return new PageImpl((List)targetContents, pageable, results.getTotalElements());
    }

    private RoleEntity buildCopyRole(RoleEntity roleEntity) {
        RoleEntity targetRole = (RoleEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)roleEntity, RoleEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        RoleEntity parentEntity = roleEntity.getParent();
        if (parentEntity != null) {
            RoleEntity targetParentEntity = (RoleEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)parentEntity, RoleEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            targetRole.setParent(targetParentEntity);
        }
        return targetRole;
    }
}

