/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac2.server.starter.service.internal;

import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.rbac2.sdk.config.RbacCustomProperties;
import com.bizunited.platform.rbac2.sdk.event.RoleEventListener;
import com.bizunited.platform.rbac2.sdk.service.RoleVoCacheService;
import com.bizunited.platform.rbac2.sdk.vo.RoleVo;
import com.bizunited.platform.rbac2.server.starter.entity.RoleEntity;
import com.bizunited.platform.rbac2.server.starter.repository.RoleRepository;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.redisson.Redisson;
import org.redisson.api.RTopic;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class RoleVoCacheServiceImpl
implements RoleVoCacheService {
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private Redisson redisson;
    @Autowired(required=false)
    private List<RoleEventListener> roleEventListeners;
    @Autowired
    private RbacCustomProperties rbacConfig;
    private static Map<String, Map<String, RoleVo>> roleCacheMapping = Maps.newConcurrentMap();
    private static Map<String, ReentrantReadWriteLock> roleLockMapping = Maps.newConcurrentMap();

    public void clearCache(String tenantCode) {
        ReentrantReadWriteLock.WriteLock writeLock = this.getWriteLockByTenantCode(tenantCode);
        try {
            writeLock.lock();
            if (roleCacheMapping != null) {
                roleCacheMapping.remove(tenantCode);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache(String tenantCode, String roleCode) {
        ReentrantReadWriteLock.WriteLock writeLock = this.getWriteLockByTenantCode(tenantCode);
        try {
            writeLock.lock();
            if (roleCacheMapping != null) {
                Map<String, RoleVo> cacheRoleMapping = roleCacheMapping.get(tenantCode);
                RoleVo cacheRole = null;
                if (cacheRoleMapping != null && (cacheRole = cacheRoleMapping.get(roleCode)) != null) {
                    cacheRole.setCacheInvalid(true);
                }
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReentrantReadWriteLock.WriteLock getWriteLockByTenantCode(String tenantCode) {
        while (roleLockMapping.get(tenantCode) == null) {
            Map<String, ReentrantReadWriteLock> map = roleLockMapping;
            synchronized (map) {
                if (roleLockMapping.get(tenantCode) == null) {
                    roleLockMapping.put(tenantCode, new ReentrantReadWriteLock());
                }
            }
        }
        ReentrantReadWriteLock lock = roleLockMapping.get(tenantCode);
        return lock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReentrantReadWriteLock.ReadLock getReadLockByTenantCode(String tenantCode) {
        while (roleLockMapping.get(tenantCode) == null) {
            Map<String, ReentrantReadWriteLock> map = roleLockMapping;
            synchronized (map) {
                if (roleLockMapping.get(tenantCode) == null) {
                    roleLockMapping.put(tenantCode, new ReentrantReadWriteLock());
                }
            }
        }
        ReentrantReadWriteLock lock = roleLockMapping.get(tenantCode);
        return lock.readLock();
    }

    public void notifyCacheRefresh(String tenantCode) {
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            return;
        }
        RTopic topic = this.redisson.getTopic("_TENANT_ROLE_NOTIFY");
        topic.publish((Object)tenantCode);
    }

    public void notifyCacheRefresh(String tenantCode, String roleCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tenantCode, roleCode})) {
            return;
        }
        RTopic topic = this.redisson.getTopic("_TENANT_ROLE_IDENTITY_NOTIFY");
        topic.publish((Object)StringUtils.join((Object[])new String[]{tenantCode, "|", roleCode}));
    }

    public String findBaseRoleCode() {
        return this.rbacConfig.getBaseRoleCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findDetailsFromRepository(String tenantCode) {
        if (StringUtils.isEmpty((CharSequence)tenantCode)) {
            return;
        }
        roleCacheMapping.remove(tenantCode);
        Set<RoleEntity> rootRoles = this.roleRepository.findByTenantCodeAndParentIsNull(tenantCode);
        if (CollectionUtils.isEmpty(rootRoles)) {
            return;
        }
        ReentrantReadWriteLock.ReadLock readLock = this.getReadLockByTenantCode(tenantCode);
        readLock.unlock();
        ReentrantReadWriteLock.WriteLock writeLock = this.getWriteLockByTenantCode(tenantCode);
        if (!writeLock.tryLock()) {
            Thread.yield();
            while (!writeLock.tryLock()) {
                Thread.yield();
            }
            writeLock.unlock();
            readLock.lock();
            return;
        }
        LinkedHashMap cacheRolesMap = Maps.newLinkedHashMap();
        try {
            for (RoleEntity rootRoleEntity : rootRoles) {
                this.recursiveLoadRole(rootRoleEntity, cacheRolesMap);
            }
            roleCacheMapping.put(tenantCode, cacheRolesMap);
        }
        finally {
            writeLock.unlock();
            readLock.lock();
        }
    }

    private void recursiveLoadRole(RoleEntity roleEntity, Map<String, RoleVo> cacheRolesMap) {
        this.findDetailsFromRepository(roleEntity.getTenantCode(), roleEntity, cacheRolesMap, false);
        Set<RoleEntity> children = this.roleRepository.findByTenantCodeAndParent(roleEntity.getTenantCode(), roleEntity.getId());
        if (!CollectionUtils.isEmpty(children)) {
            for (RoleEntity childRoleEntity : children) {
                this.recursiveLoadRole(childRoleEntity, cacheRolesMap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RoleVo findDetailsFromRepository(String tenantCode, RoleEntity roleEntity, Map<String, RoleVo> cacheRolesMap, boolean releaseLock) {
        if (roleEntity == null) {
            return null;
        }
        ReentrantReadWriteLock.ReadLock readLock = null;
        ReentrantReadWriteLock.WriteLock writeLock = null;
        if (releaseLock) {
            readLock = this.getReadLockByTenantCode(tenantCode);
            readLock.unlock();
            writeLock = this.getWriteLockByTenantCode(tenantCode);
            if (!writeLock.tryLock()) {
                Thread.yield();
                while (!writeLock.tryLock()) {
                    Thread.yield();
                }
                writeLock.unlock();
                readLock.lock();
                return cacheRolesMap.get(roleEntity.getRoleCode());
            }
        }
        RoleVo currentRole = null;
        try {
            Set<RoleEntity> children;
            currentRole = (RoleVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)roleEntity, RoleVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            currentRole.setCacheInvalid(false);
            LinkedHashMap userAccountMaps = Maps.newLinkedHashMap();
            if (!CollectionUtils.isEmpty(this.roleEventListeners)) {
                for (RoleEventListener roleEventListener : this.roleEventListeners) {
                    List eachUserAccounts = null;
                    eachUserAccounts = roleEventListener.onRequestUserAccount(currentRole.getRoleCode(), tenantCode);
                    if (CollectionUtils.isEmpty((Collection)eachUserAccounts)) continue;
                    String mouduleName = roleEventListener.moduleName();
                    Set userAccounts = null;
                    userAccounts = (Set)userAccountMaps.get(mouduleName);
                    if (CollectionUtils.isEmpty((Collection)userAccounts)) {
                        userAccounts = Sets.newLinkedHashSet((Iterable)eachUserAccounts);
                        userAccountMaps.put(mouduleName, userAccounts);
                        continue;
                    }
                    userAccounts.addAll(eachUserAccounts);
                }
            }
            if (!CollectionUtils.isEmpty((Map)userAccountMaps)) {
                currentRole.setUserAccountMaps((Map)userAccountMaps);
            }
            if (roleEntity.getParent() != null) {
                RoleEntity parentRoleEntity = roleEntity.getParent();
                RoleVo parentRoleVo = (RoleVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)parentRoleEntity, RoleVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                currentRole.setParent(parentRoleVo);
            }
            if (!CollectionUtils.isEmpty(children = this.roleRepository.findByTenantCodeAndParent(tenantCode, roleEntity.getId()))) {
                Collection childrenVos = this.nebulaToolkitService.copyCollectionByBlankList(children, RoleEntity.class, RoleVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                currentRole.setChildren((Set)Sets.newHashSet((Iterable)childrenVos));
            }
            cacheRolesMap.put(currentRole.getRoleCode(), currentRole);
        }
        finally {
            if (releaseLock) {
                writeLock.unlock();
                readLock.lock();
            }
        }
        return currentRole;
    }

    private RoleVo realFindByRoleCode(String tenantCode, String roleCode) {
        RoleVo currentCacheRole = null;
        Map<String, RoleVo> cacheRolesMapping = roleCacheMapping.get(tenantCode);
        if (cacheRolesMapping == null) {
            this.findDetailsFromRepository(tenantCode);
            cacheRolesMapping = roleCacheMapping.get(tenantCode);
        }
        if (cacheRolesMapping == null || cacheRolesMapping.isEmpty()) {
            return null;
        }
        currentCacheRole = cacheRolesMapping.get(roleCode);
        if (currentCacheRole != null && currentCacheRole.isCacheInvalid()) {
            RoleEntity roleEntity = this.roleRepository.findByTenantCodeAndRoleCode(tenantCode, roleCode);
            currentCacheRole = this.findDetailsFromRepository(tenantCode, roleEntity, cacheRolesMapping, true);
        }
        return currentCacheRole;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RoleVo findByTenantCodeAndRoleCode(String tenantCode, String roleCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tenantCode, roleCode})) {
            return null;
        }
        ReentrantReadWriteLock.ReadLock readLock = this.getReadLockByTenantCode(tenantCode);
        readLock.lock();
        try {
            RoleVo roleVo = this.realFindByRoleCode(tenantCode, roleCode);
            return roleVo;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<RoleVo> findByTenantCodeAndRoleCodes(String tenantCode, Set<String> roleCodes) {
        if (StringUtils.isBlank((CharSequence)tenantCode) || CollectionUtils.isEmpty(roleCodes)) {
            return null;
        }
        ReentrantReadWriteLock.ReadLock readLock = this.getReadLockByTenantCode(tenantCode);
        readLock.lock();
        LinkedHashSet results = Sets.newLinkedHashSet();
        try {
            for (String roleCode : roleCodes) {
                RoleVo roleVo = this.realFindByRoleCode(tenantCode, roleCode);
                if (roleVo == null) continue;
                results.add(roleVo);
            }
            LinkedHashSet linkedHashSet = results;
            return linkedHashSet;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<RoleVo> findByTenantCodeAndUserAccount(String tenantCode, String userAccount) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tenantCode, userAccount})) {
            return null;
        }
        ReentrantReadWriteLock.ReadLock readLock = this.getReadLockByTenantCode(tenantCode);
        readLock.lock();
        LinkedHashSet currentCacheRoles = Sets.newLinkedHashSet();
        try {
            Map<String, RoleVo> cacheRolesMapping = roleCacheMapping.get(tenantCode);
            if (cacheRolesMapping == null) {
                this.findDetailsFromRepository(tenantCode);
                cacheRolesMapping = roleCacheMapping.get(tenantCode);
            }
            if (cacheRolesMapping == null) {
                Set<RoleVo> set = null;
                return set;
            }
            Collection<RoleVo> roles = cacheRolesMapping.values();
            if (CollectionUtils.isEmpty(roles)) {
                Set<RoleVo> set = null;
                return set;
            }
            block5: for (RoleVo roleVo : roles) {
                Map userAccountMaps;
                if (roleVo.isCacheInvalid()) {
                    RoleEntity roleEntity = this.roleRepository.findByTenantCodeAndRoleCode(tenantCode, roleVo.getRoleCode());
                    roleVo = this.findDetailsFromRepository(tenantCode, roleEntity, cacheRolesMapping, true);
                }
                if ((userAccountMaps = roleVo.getUserAccountMaps()) == null || userAccountMaps.size() == 0) continue;
                Collection userAccountValues = userAccountMaps.values();
                for (Set userAccountValue : userAccountValues) {
                    if (!userAccountValue.contains(userAccount)) continue;
                    currentCacheRoles.add(roleVo);
                    continue block5;
                }
            }
        }
        finally {
            readLock.unlock();
        }
        return currentCacheRoles;
    }

    public Set<RoleVo> findRoleTree(String tenantCode) {
        return null;
    }

    public Set<RoleVo> findRoleTree(String tenantCode, String roleCode) {
        return null;
    }
}

