/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac2.server.starter.service.strategy;

import com.bizunited.platform.rbac2.sdk.vo.ButtonVo;
import com.bizunited.platform.rbac2.sdk.vo.CompetenceVo;
import com.bizunited.platform.rbac2.server.starter.service.strategy.AbstractCompetenceQueryStrategy;
import com.bizunited.platform.rbac2.server.starter.service.strategy.CompetenceQueryStrategy;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class QueryByButtonCodeAndRoleCodes
extends AbstractCompetenceQueryStrategy
implements CompetenceQueryStrategy {
    private String tenantCode;
    private String[] roleCodes;
    private Boolean viewItem;
    private String buttonCode;
    private boolean isAdmin;
    private String[] ignoreMethodCheckRoles;

    public QueryByButtonCodeAndRoleCodes(String tenantCode, String[] roleCodes, Boolean viewItem, String buttonCode, boolean isAdmin, String[] ignoreMethodCheckRoles) {
        this.tenantCode = tenantCode;
        this.roleCodes = roleCodes;
        this.viewItem = viewItem;
        this.buttonCode = buttonCode;
        this.isAdmin = isAdmin;
        this.ignoreMethodCheckRoles = ignoreMethodCheckRoles;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CompetenceVo filterCompetence(CompetenceVo competence) {
        Integer targetViewItem = competence.getViewItem();
        String targetRoles = competence.getRoles();
        if (this.viewItem != null && this.viewItem != (targetViewItem == 1)) {
            return null;
        }
        Set buttons = competence.getButtons();
        if (!StringUtils.isBlank((CharSequence)this.buttonCode) && !CollectionUtils.isEmpty((Collection)buttons) && buttons.stream().filter(item -> StringUtils.equals((CharSequence)item.getCode(), (CharSequence)this.buttonCode)).count() == 0L) {
            return null;
        }
        CompetenceVo copyCompetence = this.copyCompetence(competence);
        Object[] matchedRolesReuslt = new String[]{};
        if (!this.isAdmin && StringUtils.isNotBlank((CharSequence)this.tenantCode) && this.roleCodes != null && this.roleCodes.length > 0) {
            if (StringUtils.isEmpty((CharSequence)targetRoles)) return null;
            ArrayList matchTargetRoles = Lists.newArrayList();
            for (String roleCode : this.roleCodes) {
                matchTargetRoles.add(StringUtils.join((Object[])new String[]{this.tenantCode, "|", roleCode}));
            }
            String[] matchTargetRoleArray = matchTargetRoles.toArray(new String[0]);
            String[] matchedRoles = (String[])Arrays.stream(StringUtils.split((String)targetRoles, (String)",")).filter(item -> StringUtils.equalsAny((CharSequence)item, (CharSequence[])matchTargetRoleArray)).toArray(String[]::new);
            if (matchedRoles == null || matchedRoles.length == 0) {
                return null;
            }
            matchedRolesReuslt = (String[])Arrays.stream(matchedRoles).map(item -> StringUtils.split((String)item, (String)"|")[1]).toArray(String[]::new);
        } else if (this.isAdmin) {
            matchedRolesReuslt = this.ignoreMethodCheckRoles;
        }
        copyCompetence.setRoles(StringUtils.join((Object[])matchedRolesReuslt, (String)","));
        return copyCompetence;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ButtonVo filterButton(ButtonVo button) {
        void var4_8;
        Set targetRoles = button.getRoles();
        ButtonVo copyButton = (ButtonVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)button, ButtonVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        LinkedHashSet linkedHashSet = Sets.newLinkedHashSet();
        if (!this.isAdmin && StringUtils.isNotBlank((CharSequence)this.tenantCode) && this.roleCodes != null && this.roleCodes.length > 0) {
            if (CollectionUtils.isEmpty((Collection)targetRoles)) return null;
            ArrayList matchTargetRoles = Lists.newArrayList();
            for (String roleCode : this.roleCodes) {
                matchTargetRoles.add(StringUtils.join((Object[])new String[]{this.tenantCode, "|", roleCode}));
            }
            String[] matchTargetRoleArray = matchTargetRoles.toArray(new String[0]);
            String[] matchedRoles = (String[])targetRoles.stream().filter(item -> StringUtils.equalsAny((CharSequence)item, (CharSequence[])matchTargetRoleArray)).toArray(String[]::new);
            if (matchedRoles == null || matchedRoles.length == 0) {
                return null;
            }
            Set set = Arrays.stream(matchedRoles).map(item -> StringUtils.split((String)item, (String)"|")[1]).collect(Collectors.toSet());
        } else if (this.isAdmin) {
            HashSet hashSet = Sets.newHashSet((Object[])this.ignoreMethodCheckRoles);
        } else {
            Set set = targetRoles;
        }
        copyButton.setRoles((Set)var4_8);
        return copyButton;
    }
}

