/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac2.server.starter.service.strategy;

import com.bizunited.platform.rbac2.sdk.vo.ButtonVo;
import com.bizunited.platform.rbac2.sdk.vo.CompetenceVo;
import com.bizunited.platform.rbac2.server.starter.service.strategy.AbstractCompetenceQueryStrategy;
import com.bizunited.platform.rbac2.server.starter.service.strategy.CompetenceQueryStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class QueryByParentNull
extends AbstractCompetenceQueryStrategy
implements CompetenceQueryStrategy {
    private Boolean viewItem;
    private String tenantCode;
    private Integer status;

    public QueryByParentNull(Boolean viewItem, String tenantCode, Integer status) {
        this.viewItem = viewItem;
        this.tenantCode = tenantCode;
        this.status = status;
    }

    @Override
    public CompetenceVo filterCompetence(CompetenceVo competence) {
        if (this.viewItem == null || StringUtils.isBlank((CharSequence)this.tenantCode)) {
            return null;
        }
        Integer targetViewItem = competence.getViewItem();
        String targetRoles = competence.getRoles();
        if (this.viewItem != (targetViewItem == 1)) {
            return null;
        }
        if (this.status != null && this.status.intValue() != competence.getTstatus().intValue()) {
            return null;
        }
        CompetenceVo copyCompetence = this.copyCompetence(competence);
        Object[] matchedRolesReuslt = null;
        if (!StringUtils.isEmpty((CharSequence)targetRoles)) {
            String[] matchedRoles = (String[])Arrays.stream(StringUtils.split((String)targetRoles, (String)",")).filter(item -> StringUtils.indexOf((CharSequence)item, (CharSequence)(this.tenantCode + "|")) == 0).toArray(String[]::new);
            if (matchedRoles == null || matchedRoles.length == 0) {
                copyCompetence.setRoles(null);
            } else {
                matchedRolesReuslt = (String[])Arrays.stream(matchedRoles).map(item -> StringUtils.split((String)item, (String)"|")[1]).toArray(String[]::new);
                copyCompetence.setRoles(StringUtils.join((Object[])matchedRolesReuslt, (String)","));
            }
        } else {
            copyCompetence.setRoles(null);
        }
        return copyCompetence;
    }

    @Override
    public ButtonVo filterButton(ButtonVo button) {
        if (this.viewItem == null || StringUtils.isBlank((CharSequence)this.tenantCode)) {
            return null;
        }
        Set targetRoles = button.getRoles();
        ButtonVo copyButton = (ButtonVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)button, ButtonVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        Set matchedRolesReuslt = null;
        if (!CollectionUtils.isEmpty((Collection)targetRoles)) {
            String[] matchedRoles = (String[])targetRoles.stream().filter(item -> StringUtils.indexOf((CharSequence)item, (CharSequence)(this.tenantCode + "|")) == 0).toArray(String[]::new);
            if (matchedRoles == null || matchedRoles.length == 0) {
                copyButton.setRoles(null);
            } else {
                matchedRolesReuslt = Arrays.stream(matchedRoles).map(item -> StringUtils.split((String)item, (String)"|")[1]).collect(Collectors.toSet());
                copyButton.setRoles(matchedRolesReuslt);
            }
        } else {
            copyButton.setRoles(null);
        }
        return copyButton;
    }
}

