/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.saturn.context.service.simple;

import com.bizunited.platform.saturn.context.service.PersistentClassService;
import com.bizunited.platform.saturn.model.PersistentClass;
import com.bizunited.platform.saturn.model.PersistentProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.ehcache.Cache;

class SimplePersistentClassService
implements PersistentClassService {
    private Cache<String, PersistentClass> cache;
    private static final String[] PERSISTENT_CLASS_NAMES = new String[]{""};

    public SimplePersistentClassService(Cache<String, PersistentClass> cache) {
        this.cache = cache;
    }

    @Override
    public void refreshAllPersistent(Map<String, PersistentClass> persistentMappingClasses) {
        this.cache.clear();
        if (persistentMappingClasses != null && !persistentMappingClasses.isEmpty()) {
            this.cache.putAll(persistentMappingClasses);
        }
    }

    @Override
    public void save(PersistentClass persistentClass) {
        Validate.notNull((Object)persistentClass, (String)"persistentClass not be null!!", (Object[])new Object[0]);
        String clssName = persistentClass.getClassName();
        Validate.notBlank((CharSequence)clssName, (String)"clssName not be null", (Object[])new Object[0]);
        this.cache.put((Object)clssName, (Object)persistentClass);
    }

    @Override
    public void delete(String className) {
        if (StringUtils.isBlank((CharSequence)className)) {
            return;
        }
        this.cache.remove((Object)className);
    }

    @Override
    public List<PersistentClass> queryAllClasses() {
        Iterator iterators = this.cache.iterator();
        HashMap<String, PersistentClass> persistentClassMapping = new HashMap<String, PersistentClass>();
        while (iterators.hasNext()) {
            Cache.Entry entry = (Cache.Entry)iterators.next();
            PersistentClass persistentClassValues = (PersistentClass)entry.getValue();
            persistentClassMapping.put(persistentClassValues.getClassName(), persistentClassValues);
        }
        return new LinkedList<PersistentClass>(persistentClassMapping.values());
    }

    @Override
    public PersistentClass queryByClassName(String className) {
        if (StringUtils.isBlank((CharSequence)className)) {
            return null;
        }
        return (PersistentClass)this.cache.get((Object)className);
    }

    @Override
    public List<PersistentClass> queryByDomainName(String domainName) {
        if (StringUtils.isBlank((CharSequence)domainName)) {
            return new ArrayList<PersistentClass>();
        }
        LinkedList<PersistentClass> domainPersistentClasses = new LinkedList<PersistentClass>();
        List<PersistentClass> classes = this.queryAllClasses();
        for (PersistentClass persistentClass : classes) {
            String domain = persistentClass.getDomain();
            if (!StringUtils.equals((CharSequence)domain, (CharSequence)domainName)) continue;
            domainPersistentClasses.add(persistentClass);
        }
        return domainPersistentClasses;
    }

    @Override
    public boolean isFormInstancePersistent(String persistentClassName) {
        if (StringUtils.isBlank((CharSequence)persistentClassName)) {
            return false;
        }
        PersistentClass persistentClass = this.queryByClassName(persistentClassName);
        if (persistentClass == null) {
            return false;
        }
        List<PersistentProperty> persistentProperties = persistentClass.getProperties();
        if (persistentProperties == null || persistentProperties.isEmpty()) {
            return false;
        }
        Class<?> targetPersistentClass = null;
        try {
            targetPersistentClass = Class.forName(persistentClassName);
            Class<?> superclass = null;
            while ((superclass = targetPersistentClass.getSuperclass()) != null) {
                String superclassName = superclass.getName();
                if (StringUtils.equalsAny((CharSequence)superclassName, (CharSequence[])PERSISTENT_CLASS_NAMES)) {
                    return true;
                }
                targetPersistentClass = superclass;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        for (PersistentProperty persistentProperty : persistentProperties) {
            if (!StringUtils.equals((CharSequence)persistentProperty.getPropertyName(), (CharSequence)"formInstanceId")) continue;
            return true;
        }
        return false;
    }
}

