/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.saturn.context.service.simple;

import com.bizunited.platform.saturn.context.service.PersistentPropertyService;
import com.bizunited.platform.saturn.model.PersistentClass;
import com.bizunited.platform.saturn.model.PersistentProperty;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.ehcache.Cache;

class SimplePersistentPropertyService
implements PersistentPropertyService {
    private Cache<String, PersistentClass> cache;

    public SimplePersistentPropertyService(Cache<String, PersistentClass> cache) {
        this.cache = cache;
    }

    @Override
    public void save(PersistentProperty property) {
        int index;
        Validate.notNull((Object)property, (String)"[save]\uff0c\u9519\u8bef\u7684property\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String persistentClassName = property.getPersistentClassName();
        Validate.notBlank((CharSequence)persistentClassName, (String)"\u5fc5\u987b\u6307\u5b9a\u6a21\u578b\u7c7b\u7684\u5168\u540d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String propertyName = property.getPropertyName();
        Validate.notBlank((CharSequence)propertyName, (String)"\u5fc5\u987b\u6307\u5b9a\u5c5e\u6027\u540d", (Object[])new Object[0]);
        String propertyClass = property.getPropertyClass();
        Validate.notBlank((CharSequence)propertyClass, (String)"\u5fc5\u987b\u6307\u5b9a\u5c5e\u6027\u7c7b\u578b", (Object[])new Object[0]);
        PersistentClass persistentClass = (PersistentClass)this.cache.get((Object)persistentClassName);
        Validate.notNull((Object)persistentClass, (String)("\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u7c7b\u6a21\u578b[" + persistentClassName + "]"), (Object[])new Object[0]);
        List<PersistentProperty> properties = persistentClass.getProperties();
        if (properties == null) {
            properties = new LinkedList<PersistentProperty>();
            persistentClass.setProperties(properties);
        }
        boolean found = false;
        for (index = 0; index < properties.size(); ++index) {
            PersistentProperty propertyItem = properties.get(index);
            if (!StringUtils.equals((CharSequence)propertyName, (CharSequence)propertyItem.getPropertyName())) continue;
            found = true;
            break;
        }
        if (found) {
            properties.set(index, property);
        } else {
            properties.add(property);
        }
    }

    @Override
    public Map<String, PersistentProperty> findByClassName(String className) {
        if (StringUtils.isBlank((CharSequence)className)) {
            return null;
        }
        PersistentClass persistentClass = (PersistentClass)this.cache.get((Object)className);
        if (persistentClass == null) {
            return null;
        }
        List<PersistentProperty> properties = persistentClass.getProperties();
        if (properties == null || properties.isEmpty()) {
            return null;
        }
        Map<String, PersistentProperty> propertyMapping = null;
        propertyMapping = properties.stream().collect(Collectors.toMap(PersistentProperty::getPropertyName, persistentProperty -> persistentProperty));
        return propertyMapping;
    }

    @Override
    public PersistentProperty findPrimaryKey(String className) {
        if (StringUtils.isBlank((CharSequence)className)) {
            return null;
        }
        PersistentClass persistentClass = (PersistentClass)this.cache.get((Object)className);
        List<PersistentProperty> properties = persistentClass.getProperties();
        if (properties == null || properties.isEmpty()) {
            return null;
        }
        List primaryKeys = properties.stream().filter(PersistentProperty::getPrimaryKey).collect(Collectors.toList());
        if (primaryKeys == null || primaryKeys.isEmpty()) {
            return null;
        }
        return (PersistentProperty)primaryKeys.get(0);
    }

    @Override
    public PersistentProperty findByPropertyName(String className, String propertyName) {
        if (StringUtils.isBlank((CharSequence)className) || StringUtils.isBlank((CharSequence)propertyName)) {
            return null;
        }
        PersistentClass persistentClass = (PersistentClass)this.cache.get((Object)className);
        if (persistentClass == null) {
            return null;
        }
        List<PersistentProperty> properties = persistentClass.getProperties();
        if (properties == null || properties.isEmpty()) {
            return null;
        }
        for (PersistentProperty propertyItem : properties) {
            if (!StringUtils.equals((CharSequence)propertyName, (CharSequence)propertyItem.getPropertyName())) continue;
            return propertyItem;
        }
        return null;
    }
}

