/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.saturn.context.service.simple;

import com.bizunited.platform.saturn.context.service.PersistentUpdateMethodService;
import com.bizunited.platform.saturn.model.PersistentClass;
import com.bizunited.platform.saturn.model.PersistentUpdateMethod;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.ehcache.Cache;

class SimpleUpdateMethodService
implements PersistentUpdateMethodService {
    private Cache<String, PersistentClass> cache;

    public SimpleUpdateMethodService(Cache<String, PersistentClass> cache) {
        this.cache = cache;
    }

    @Override
    public void save(PersistentUpdateMethod updateMethod) {
        List currentMethodNames;
        int foundIndex;
        Validate.notNull((Object)updateMethod, (String)"\u65b0\u589e\u7684\u65b9\u6cd5\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        String description = updateMethod.getDescription();
        Validate.notBlank((CharSequence)description, (String)"\u65b9\u6cd5\u63cf\u8ff0\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        String persistentClassName = updateMethod.getPersistentClassName();
        Validate.notBlank((CharSequence)persistentClassName, (String)"\u5fc5\u987b\u6307\u5b9a\u6a21\u578b\u7c7b\u7684\u5168\u540d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        PersistentClass persistentClass = (PersistentClass)this.cache.get((Object)persistentClassName);
        Validate.notNull((Object)persistentClass, (String)("\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u7c7b\u6a21\u578b[" + persistentClassName + "]"), (Object[])new Object[0]);
        String[] updateParams = updateMethod.getUpdateParams();
        Validate.isTrue((updateParams != null && updateParams.length > 0 ? 1 : 0) != 0, (String)"\u8bf7\u81f3\u5c11\u6307\u5b9a\u4e00\u4e2a\u66f4\u65b0\u53c2\u6570\u4fe1\u606f!!", (Object[])new Object[0]);
        String[] queryParams = updateMethod.getQueryParams();
        Validate.isTrue((queryParams != null && queryParams.length > 0 ? 1 : 0) != 0, (String)"\u8bf7\u81f3\u5c11\u6307\u5b9a\u4e00\u4e2a\u6761\u4ef6\u53c2\u6570\u4fe1\u606f!!", (Object[])new Object[0]);
        String methodName = updateMethod.getMethodName();
        Validate.isTrue((boolean)StringUtils.startsWith((CharSequence)methodName, (CharSequence)"update"), (String)"\u81ea\u5b9a\u4e49\u66f4\u65b0\u65b9\u6cd5\u5fc5\u987b\u4ee5update\u5173\u952e\u5b57\u5f00\u59cb!!", (Object[])new Object[0]);
        List<PersistentUpdateMethod> updateMethods = persistentClass.getUpdateMethods();
        if (updateMethods == null) {
            updateMethods = new LinkedList<PersistentUpdateMethod>();
            persistentClass.setUpdateMethods(updateMethods);
        }
        if ((foundIndex = (currentMethodNames = updateMethods.stream().map(PersistentUpdateMethod::getMethodName).collect(Collectors.toList())).indexOf(methodName)) != -1) {
            updateMethods.set(foundIndex, updateMethod);
        } else {
            updateMethods.add(updateMethod);
        }
    }

    @Override
    public List<PersistentUpdateMethod> queryByClassName(String className) {
        if (StringUtils.isBlank((CharSequence)className)) {
            return new ArrayList<PersistentUpdateMethod>();
        }
        PersistentClass persistentClass = (PersistentClass)this.cache.get((Object)className);
        if (persistentClass == null) {
            return new ArrayList<PersistentUpdateMethod>();
        }
        return persistentClass.getUpdateMethods();
    }
}

