/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.saturn.engine;

import com.bizunited.platform.saturn.context.SaturnContext;
import com.bizunited.platform.saturn.context.SimpleSaturnContext;
import com.bizunited.platform.saturn.context.service.PersistentClassService;
import com.bizunited.platform.saturn.context.service.PersistentPropertyService;
import com.bizunited.platform.saturn.context.service.PersistentQueryMethodService;
import com.bizunited.platform.saturn.context.service.PersistentRelationService;
import com.bizunited.platform.saturn.context.service.PersistentServiceFactory;
import com.bizunited.platform.saturn.context.service.PersistentUpdateMethodService;
import com.bizunited.platform.saturn.engine.SaturnFuture;
import com.bizunited.platform.saturn.engine.SaturnFutureImpl;
import com.bizunited.platform.saturn.engine.handler.AbstractGenerateHandler;
import com.bizunited.platform.saturn.model.PersistentClass;
import com.bizunited.platform.saturn.scan.ClassScanner;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SaturnEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaturnEngine.class);
    private SaturnContext saturnContext;
    private Set<ClassScanner> classScanners;
    private Set<AbstractGenerateHandler> generateHandlers;

    private SaturnEngine(SaturnContext saturnContext) {
        this.saturnContext = saturnContext;
    }

    public SaturnFuture eve(URL ... classFolderUrls) {
        SaturnFutureImpl saturnFuture = new SaturnFutureImpl(this.saturnContext);
        Thread saturnRunnable = new Thread(() -> {
            LinkedList currentPersistentClasses = new LinkedList();
            try {
                for (ClassScanner classScannerItem : this.classScanners) {
                    currentPersistentClasses.addAll((Collection)classScannerItem.handle(this.saturnContext));
                }
                Map<String, PersistentClass> persistentClassMapping = currentPersistentClasses.stream().collect(Collectors.toMap(PersistentClass::getClassName, persistentClass -> persistentClass));
                PersistentClassService persistentClassService = this.saturnContext.getPersistentClassService();
                persistentClassService.refreshAllPersistent(persistentClassMapping);
                this.saturnContext.setInited(true);
            }
            catch (Exception e) {
                this.saturnContext.setException(true);
                this.saturnContext.setErrorMgs(e.getMessage());
                LOGGER.error(e.getMessage(), (Throwable)e);
                this.saturnContext.setCompleted(true);
                SaturnFuture persistentClassService = saturnFuture;
                synchronized (persistentClassService) {
                    saturnFuture.notify();
                }
                return;
            }
            try {
                if (!this.saturnContext.getOnlyScan().booleanValue() && this.generateHandlers != null && !this.generateHandlers.isEmpty()) {
                    for (AbstractGenerateHandler generateHandler : this.generateHandlers) {
                        generateHandler.handle(this.saturnContext);
                    }
                }
            }
            catch (Exception e) {
                this.saturnContext.setException(true);
                this.saturnContext.setErrorMgs(e.getMessage());
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            finally {
                this.saturnContext.setCompleted(true);
                SaturnFuture saturnFuture2 = saturnFuture;
                synchronized (saturnFuture2) {
                    saturnFuture.notify();
                }
            }
        });
        Thread saturnThread = new Thread((Runnable)saturnRunnable, "Saturn Engine Thread");
        if (classFolderUrls != null && classFolderUrls.length > 0) {
            URLClassLoader currentClassLoader = new URLClassLoader(classFolderUrls, Thread.currentThread().getContextClassLoader());
            saturnThread.setContextClassLoader(currentClassLoader);
        } else {
            saturnThread.setContextClassLoader(Thread.currentThread().getContextClassLoader());
        }
        saturnThread.start();
        return saturnFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eve() {
        LinkedList currentPersistentClasses = new LinkedList();
        try {
            for (ClassScanner classScannerItem : this.classScanners) {
                currentPersistentClasses.addAll((Collection)classScannerItem.handle(this.saturnContext));
            }
            Map<String, PersistentClass> persistentClassMapping = currentPersistentClasses.stream().collect(Collectors.toMap(PersistentClass::getClassName, persistentClass -> persistentClass));
            PersistentClassService persistentClassService = this.saturnContext.getPersistentClassService();
            persistentClassService.refreshAllPersistent(persistentClassMapping);
            this.saturnContext.setInited(true);
        }
        catch (Exception e) {
            this.saturnContext.setException(true);
            this.saturnContext.setErrorMgs(e.getMessage());
            LOGGER.error(e.getMessage(), (Throwable)e);
            this.saturnContext.setCompleted(true);
            return;
        }
        try {
            if (!this.saturnContext.getOnlyScan().booleanValue() && this.generateHandlers != null && !this.generateHandlers.isEmpty()) {
                for (AbstractGenerateHandler generateHandler : this.generateHandlers) {
                    generateHandler.handle(this.saturnContext);
                }
            }
        }
        catch (Exception e) {
            this.saturnContext.setException(true);
            this.saturnContext.setErrorMgs(e.getMessage());
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.saturnContext.setCompleted(true);
        }
    }

    public SaturnContext getSaturnContext() {
        return this.saturnContext;
    }

    public static class Builder {
        private PersistentServiceFactory persistentServiceFactory;
        private File projectRoot;
        private String[] rootScanPackages;
        private String projectRootPackage;
        private String projectSrcPath = "src/test/java";
        private Boolean onlyScan = false;
        private Boolean onlyBuildEntity = false;
        private Boolean onlyBuildVo = false;
        private Set<ClassScanner> classScanners;
        private Set<AbstractGenerateHandler> generateHandlers;

        public Builder setProjectRoot(File projectRoot) {
            if (projectRoot == null) {
                return this;
            }
            this.projectRoot = projectRoot;
            return this;
        }

        public Builder setPersistentServiceFactory(PersistentServiceFactory persistentServiceFactory) {
            this.persistentServiceFactory = persistentServiceFactory;
            return this;
        }

        public Builder setProjectSrcPath(String projectSrcPath) {
            this.projectSrcPath = projectSrcPath;
            return this;
        }

        public Builder onlyScan(Boolean onlyScan) {
            this.onlyScan = onlyScan;
            return this;
        }

        public Builder setProjectRootPackage(String projectRootPackage) {
            this.projectRootPackage = projectRootPackage;
            return this;
        }

        public Builder setRootScanPackages(String[] rootScanPackages) {
            this.rootScanPackages = rootScanPackages;
            return this;
        }

        public Builder onlyBuildEntity(Boolean onlyBuildEntity) {
            this.onlyBuildEntity = onlyBuildEntity;
            return this;
        }

        public Builder onlyBuildVo(Boolean onlyBuildVo) {
            this.onlyBuildVo = onlyBuildVo;
            return this;
        }

        public Builder addClassScanners(ClassScanner classScanner) {
            if (classScanner == null) {
                return this;
            }
            if (this.classScanners == null) {
                this.classScanners = new LinkedHashSet<ClassScanner>();
            }
            this.classScanners.add(classScanner);
            return this;
        }

        public Builder addGenerateHandlers(AbstractGenerateHandler generateHandler) {
            if (generateHandler == null) {
                return this;
            }
            if (this.generateHandlers == null) {
                this.generateHandlers = new LinkedHashSet<AbstractGenerateHandler>();
            }
            this.generateHandlers.add(generateHandler);
            return this;
        }

        public SaturnEngine build() {
            Validate.isTrue((this.rootScanPackages != null && this.rootScanPackages.length > 0 ? 1 : 0) != 0, (String)"\u5fc5\u987b\u8bbe\u5b9a\u9759\u6001\u6a21\u578b\u626b\u63cf\u6839\u76ee\u5f55!!", (Object[])new Object[0]);
            Validate.notNull((Object)this.persistentServiceFactory, (String)"\u5fc5\u987b\u8bbe\u5b9a\u6a21\u578b\u670d\u52a1\u5c42\u5de5\u5382\uff08\u5426\u5219\u65e0\u6cd5\u5411\u5916\u90e8\u8c03\u7528\u8005\u63d0\u4f9b\u670d\u52a1\uff09", (Object[])new Object[0]);
            if (!Boolean.TRUE.equals(this.onlyScan)) {
                Validate.notNull((Object)this.projectRoot, (String)"\u5fc5\u987b\u8bbe\u5b9a\u5f53\u524d\u5de5\u7a0b\u7684\u5b8c\u6574\u5de5\u4f5c\u76ee\u5f55!!", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)this.projectRootPackage, (String)"\u5fc5\u987b\u8bbe\u5b9a\u5f53\u524d\u5de5\u7a0b\u7684\u6839\u5305\u8def\u5f84!!", (Object[])new Object[0]);
                Validate.isTrue((this.classScanners != null && !this.classScanners.isEmpty() ? 1 : 0) != 0, (String)"\u5fc5\u987b\u8bbe\u5b9a\u81f3\u5c11\u4e00\u4e2a\u7c7b\u626b\u63cf\u5904\u7406\u5668!!", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)this.projectSrcPath, (String)"\u5de5\u7a0b\u4e3b\u6e90\u4ee3\u7801\u8def\u5f84\u5fc5\u987b\u6307\u5b9a!!", (Object[])new Object[0]);
            }
            PersistentClassService persistentClassService = this.persistentServiceFactory.createPersistentClassService();
            PersistentPropertyService persistentPropertyService = this.persistentServiceFactory.createPersistentPropertyService();
            PersistentQueryMethodService persistentQueryMethodService = this.persistentServiceFactory.createPersistentQueryMethodService();
            PersistentRelationService persistentRelationService = this.persistentServiceFactory.createPersistentRelationService();
            PersistentUpdateMethodService persistentUpdateMethodService = this.persistentServiceFactory.createPersistentUpdateMethodService();
            Validate.notNull((Object)persistentClassService, (String)"\u8bf7\u5728\u6a21\u578b\u670d\u52a1\u5de5\u5382\u4e2d\uff0c\u5b8c\u6210persistentClassService\u5b9e\u4f8b\u7684\u751f\u6210!!", (Object[])new Object[0]);
            Validate.notNull((Object)persistentPropertyService, (String)"\u8bf7\u5728\u6a21\u578b\u670d\u52a1\u5de5\u5382\u4e2d\uff0c\u5b8c\u6210persistentClassService\u5b9e\u4f8b\u7684\u751f\u6210!!", (Object[])new Object[0]);
            Validate.notNull((Object)persistentQueryMethodService, (String)"\u8bf7\u5728\u6a21\u578b\u670d\u52a1\u5de5\u5382\u4e2d\uff0c\u5b8c\u6210persistentClassService\u5b9e\u4f8b\u7684\u751f\u6210!!", (Object[])new Object[0]);
            Validate.notNull((Object)persistentRelationService, (String)"\u8bf7\u5728\u6a21\u578b\u670d\u52a1\u5de5\u5382\u4e2d\uff0c\u5b8c\u6210persistentClassService\u5b9e\u4f8b\u7684\u751f\u6210!!", (Object[])new Object[0]);
            Validate.notNull((Object)persistentUpdateMethodService, (String)"\u8bf7\u5728\u6a21\u578b\u670d\u52a1\u5de5\u5382\u4e2d\uff0c\u5b8c\u6210persistentClassService\u5b9e\u4f8b\u7684\u751f\u6210!!", (Object[])new Object[0]);
            SimpleSaturnContext saturnContext = new SimpleSaturnContext();
            saturnContext.setPersistentClassService(persistentClassService);
            saturnContext.setPersistentPropertyService(persistentPropertyService);
            saturnContext.setPersistentQueryMethodService(persistentQueryMethodService);
            saturnContext.setPersistentRelationService(persistentRelationService);
            saturnContext.setPersistentUpdateMethodService(persistentUpdateMethodService);
            saturnContext.setRootScanPackages(this.rootScanPackages);
            if (!Boolean.TRUE.equals(this.onlyScan)) {
                saturnContext.setProjectAbsolutePath(this.projectRoot.getAbsolutePath());
                saturnContext.setProjectSrcPath(this.projectSrcPath);
                saturnContext.setRootPackage(this.projectRootPackage);
            }
            saturnContext.setOnlyScan(this.onlyScan);
            saturnContext.setOnlyBuildVo(this.onlyBuildVo);
            saturnContext.setOnlyBuildEntity(this.onlyBuildEntity);
            SaturnEngine saturnEngine = new SaturnEngine(saturnContext);
            saturnEngine.classScanners = this.classScanners;
            if (!Boolean.TRUE.equals(this.onlyScan)) {
                saturnEngine.generateHandlers = this.generateHandlers;
            }
            saturnEngine.saturnContext = saturnContext;
            return saturnEngine;
        }
    }
}

