/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.saturn.engine.handler;

import com.bizunited.platform.saturn.context.service.PersistentClassService;
import com.bizunited.platform.saturn.context.service.PersistentPropertyService;
import com.bizunited.platform.saturn.context.service.PersistentRelationService;
import com.bizunited.platform.saturn.engine.handler.SaturnHandler;
import com.bizunited.platform.saturn.model.PersistentClass;
import com.bizunited.platform.saturn.model.PersistentProperty;
import com.bizunited.platform.saturn.model.PersistentQueryMethod;
import com.bizunited.platform.saturn.model.PersistentRelation;
import com.bizunited.platform.saturn.model.PersistentUpdateMethod;
import com.bizunited.platform.saturn.utils.TStringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGenerateHandler
implements SaturnHandler<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractGenerateHandler.class);
    protected static final List<String> IGNOREPACKAGES = Arrays.asList("com.bizunited.platform.core.entity", "com.bizunited.platform.kuiper.entity", "com.bizunited.platform.kuiper.vo", "com.bizunited.platform.titan.entity");

    protected void buildJavaFile(String fileContexts, String projectSrcAbsolutePath, String packageName, String simpleClassName) {
        if (StringUtils.isBlank((CharSequence)fileContexts) || StringUtils.isBlank((CharSequence)projectSrcAbsolutePath) || StringUtils.isBlank((CharSequence)packageName) || StringUtils.isBlank((CharSequence)simpleClassName)) {
            LOGGER.warn("\u9519\u8bef\u7684\u6587\u4ef6\u5185\u5bb9\u6216\u8005\u5730\u5740\u683c\u5f0f\uff0c\u8be5\u6587\u4ef6\u521b\u5efa\u8fc7\u7a0b\u88ab\u5ffd\u7565\uff0c\u8bf7\u68c0\u67e5!!");
            return;
        }
        String packagePath = RegExUtils.replaceAll((String)packageName, (String)"\\.", (String)"/");
        String javaDirAbsolutePath = StringUtils.join((Object[])new String[]{projectSrcAbsolutePath, "/", packagePath});
        String javaFileName = StringUtils.join((Object[])new String[]{simpleClassName, ".java"});
        String javaFileAbsolutePath = StringUtils.join((Object[])new String[]{javaDirAbsolutePath, "/", javaFileName});
        String javaFileAbsoluteBakPath = StringUtils.join((Object[])new String[]{javaDirAbsolutePath, "/", javaFileName, ".bak"});
        File currentDir = new File(javaDirAbsolutePath);
        currentDir.mkdirs();
        Properties initProp = new Properties(System.getProperties());
        String currentFileEncoding = initProp.getProperty("file.encoding");
        byte[] currentFileContexts = !StringUtils.equals((CharSequence)currentFileEncoding, (CharSequence)"UTF-8") ? AbstractGenerateHandler.getUTF8BytesFromGBKString(fileContexts) : fileContexts.getBytes(Charset.forName("UTF-8"));
        File javaFile = new File(javaFileAbsolutePath);
        File javaBakFile = new File(javaFileAbsoluteBakPath);
        boolean javaFileExist = javaFile.exists();
        if (!javaFileExist) {
            try {
                this.writeFile(javaFile, currentFileContexts);
                LOGGER.info("\u5df2\u751f\u6210\u6e90\u4ee3\u7801\u6587\u4ef6(java)\uff1a" + javaFileName);
                return;
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return;
            }
        }
        try {
            String oldFileContent = this.readFile(javaFile);
            String currentFileContent = new String(currentFileContexts);
            if (StringUtils.equals((CharSequence)oldFileContent, (CharSequence)currentFileContent)) {
                return;
            }
            this.writeFile(javaBakFile, currentFileContexts);
            LOGGER.info("\u6e90\u4ee3\u7801\u6587\u4ef6\u5df2\u5b58\u5728\u751f\u6210.bak\u6587\u4ef6(java.bak)\uff1a" + javaFileName);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return;
        }
    }

    private void writeFile(File file, byte[] currentFileContexts) throws IOException {
        file.createNewFile();
        try (ByteArrayInputStream in = new ByteArrayInputStream(currentFileContexts);
             FileOutputStream out = new FileOutputStream(file);){
            int realLen;
            int maxlen = 9068;
            byte[] lenBytes = new byte[maxlen];
            while ((realLen = ((InputStream)in).read(lenBytes, 0, maxlen)) != -1) {
                ((OutputStream)out).write(lenBytes, 0, realLen);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private String readFile(File currentFile) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected StringBuffer scanAndBuildRelationQueryMethods(PersistentClass persistentClass, Map<String, String> importMapping, PersistentClassService persistentClassService, PersistentPropertyService persistentPropertyService, PersistentRelationService persistentRelationService) {
        StringBuffer codeView = new StringBuffer();
        List<PersistentRelation> persistentRelations = persistentClass.getRelations();
        if (persistentRelations == null || persistentRelations.isEmpty()) {
            return codeView;
        }
        String className = persistentClass.getClassName();
        if (persistentClassService.isFormInstancePersistent(className)) {
            return codeView;
        }
        for (PersistentRelation persistentRelation : persistentRelations) {
            String persistentClassName = persistentRelation.getPropertyClass();
            String property = persistentRelation.getPropertyName();
            String propertyDesc = persistentRelation.getPropertyDesc();
            PersistentProperty currentPersistent = persistentPropertyService.findPrimaryKey(persistentClassName);
            Validate.notNull((Object)currentPersistent, (String)"\u672a\u627e\u5230\u6307\u5b9a\u6a21\u578b%s\uff0c\u6700\u53ef\u80fd\u7684\u60c5\u51b5\u662f\u8fd9\u4e2a\u6a21\u578b\u7684\u5305\u8def\u5f84\u672a\u52a0\u5165\u5230kuiper\u8868\u5355\u5f15\u64ce\u7684\u6a21\u578b\u626b\u63cf\u8def\u5f84\u4e2d\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u9879!!", (Object[])new Object[]{persistentClassName});
            String pkName = currentPersistent.getPropertyName();
            String paramName = property + TStringUtils.letterUppercase(pkName);
            if (StringUtils.isBlank((CharSequence)property) || StringUtils.isBlank((CharSequence)propertyDesc) || StringUtils.isBlank((CharSequence)pkName) || StringUtils.isBlank((CharSequence)paramName)) {
                LOGGER.warn("\u9519\u8bef\u7684\u5173\u8054\u5c5e\u6027\u4fe1\u606f\uff0c\u672c\u6b21\u65b9\u6cd5\u751f\u6210\u88ab\u5ffd\u7565\uff0c\u8bf7\u68c0\u67e5!!");
                continue;
            }
            if (persistentRelation.getRelationType() != PersistentRelation.RelationType.OneToOne && persistentRelation.getRelationType() != PersistentRelation.RelationType.ManyToOne && persistentRelation.getRelationType() != PersistentRelation.RelationType.ManyToMany) continue;
            this.buildDetailsQueryMethod(codeView, persistentClass, persistentRelation, importMapping, persistentClassService, persistentPropertyService, persistentRelationService);
        }
        return codeView;
    }

    protected StringBuffer scanAndBuildCustomQueryMethods(PersistentClass persistentClass, PersistentClassService persistentClassService, PersistentPropertyService persistentPropertyService, PersistentRelationService persistentRelationService, Map<String, String> importMapping) {
        StringBuffer codeView = new StringBuffer();
        List<PersistentQueryMethod> persistentQueryMethods = persistentClass.getQueryMethods();
        String simpleClassName = persistentClass.getSimpleClassName();
        if (persistentQueryMethods == null || persistentQueryMethods.isEmpty() || StringUtils.isBlank((CharSequence)simpleClassName)) {
            return codeView;
        }
        for (PersistentQueryMethod queryMethodItem : persistentQueryMethods) {
            String methodName = queryMethodItem.getMethodName();
            String description = queryMethodItem.getDescription();
            String[] params = queryMethodItem.getParams();
            PersistentQueryMethod.QueryType[] queryTypes = queryMethodItem.getQueryTypes();
            if (StringUtils.isBlank((CharSequence)methodName) || StringUtils.isBlank((CharSequence)description) || params == null || params.length == 0 || queryTypes == null || queryTypes.length == 0 || params.length != queryTypes.length) {
                LOGGER.warn("\u81ea\u5b9a\u4e49\u67e5\u8be2[" + simpleClassName + "]\uff0c\u5b58\u5728\u53c2\u6570\u9519\u8bef\uff0c\u5ffd\u7565\u4e00\u4e2a\u9519\u8bef\u7684\u81ea\u5b9a\u4e49\u67e5\u8be2\u65b9\u6cd5\u7684\u6784\u5efa\uff0c\u8bf7\u68c0\u67e5!!");
                continue;
            }
            this.buildCustomQueryMethods(codeView, persistentClass, queryMethodItem, persistentClassService, persistentPropertyService, persistentRelationService, importMapping);
        }
        return codeView;
    }

    protected StringBuffer scanAndBuildCustomUpdateMethods(PersistentClass persistentClass, Map<String, String> importMapping, PersistentPropertyService persistentPropertyService, PersistentRelationService persistentRelationService) {
        StringBuffer codeView = new StringBuffer();
        List<PersistentUpdateMethod> persistentUpdateMethods = persistentClass.getUpdateMethods();
        if (persistentUpdateMethods == null || persistentUpdateMethods.isEmpty()) {
            return codeView;
        }
        for (PersistentUpdateMethod updateMethodItem : persistentUpdateMethods) {
            String description = updateMethodItem.getDescription();
            String[] queryParams = updateMethodItem.getQueryParams();
            String[] updateParams = updateMethodItem.getUpdateParams();
            String methodName = updateMethodItem.getMethodName();
            if (StringUtils.isBlank((CharSequence)description) || StringUtils.isBlank((CharSequence)methodName) || queryParams == null || queryParams.length == 0 || updateParams == null || updateParams.length == 0) continue;
            this.buildCustomUpdateMethods(codeView, updateMethodItem, persistentClass, importMapping, persistentPropertyService, persistentRelationService);
        }
        return codeView;
    }

    protected StringBuffer scanAndbuildUniquenessQueryMethod(PersistentClass persistentClass, Map<String, String> importMapping, PersistentClassService persistentClassService, PersistentPropertyService persistentPropertyService, PersistentRelationService persistentRelationService) {
        StringBuffer codeView = new StringBuffer();
        List<PersistentProperty> persistentProperties = persistentClass.getProperties();
        List uniqueProperties = persistentProperties.stream().filter(PersistentProperty::getUnique).collect(Collectors.toList());
        for (PersistentProperty persistentProperty : uniqueProperties) {
            if (persistentProperty.getPrimaryKey().booleanValue()) {
                this.buildDetailsQueryMethod(codeView, persistentClass, persistentProperty, importMapping, persistentClassService, persistentPropertyService, persistentRelationService);
                this.buildPkQueryMethod(codeView, persistentClass, persistentProperty, importMapping);
                this.buildPkDeleteMethod(codeView, persistentClass, persistentProperty, importMapping, persistentClassService);
                continue;
            }
            if (StringUtils.equals((CharSequence)persistentProperty.getPropertyName(), (CharSequence)"formInstanceId")) {
                this.buildDetailsQueryMethod(codeView, persistentClass, persistentProperty, importMapping, persistentClassService, persistentPropertyService, persistentRelationService);
                this.buildUniquenessQueryMethod(codeView, persistentClass, persistentProperty, importMapping);
                continue;
            }
            this.buildUniquenessQueryMethod(codeView, persistentClass, persistentProperty, importMapping);
        }
        return codeView;
    }

    protected abstract void buildRelationQueryMethods(StringBuffer var1, PersistentClass var2, PersistentRelation var3, PersistentProperty var4, PersistentClassService var5, Map<String, String> var6);

    protected abstract void buildCustomQueryMethods(StringBuffer var1, PersistentClass var2, PersistentQueryMethod var3, PersistentClassService var4, PersistentPropertyService var5, PersistentRelationService var6, Map<String, String> var7);

    protected abstract void buildCustomUpdateMethods(StringBuffer var1, PersistentUpdateMethod var2, PersistentClass var3, Map<String, String> var4, PersistentPropertyService var5, PersistentRelationService var6);

    protected abstract void buildUniquenessQueryMethod(StringBuffer var1, PersistentClass var2, PersistentProperty var3, Map<String, String> var4);

    protected abstract void buildDetailsQueryMethod(StringBuffer var1, PersistentClass var2, PersistentProperty var3, Map<String, String> var4, PersistentClassService var5, PersistentPropertyService var6, PersistentRelationService var7);

    protected abstract void buildDetailsQueryMethod(StringBuffer var1, PersistentClass var2, PersistentRelation var3, Map<String, String> var4, PersistentClassService var5, PersistentPropertyService var6, PersistentRelationService var7);

    protected abstract void buildPkQueryMethod(StringBuffer var1, PersistentClass var2, PersistentProperty var3, Map<String, String> var4);

    protected abstract void buildPkDeleteMethod(StringBuffer var1, PersistentClass var2, PersistentProperty var3, Map<String, String> var4, PersistentClassService var5);

    protected Set<String> buildWhiteProperties(PersistentClass persistentClass, PersistentClassService persistentClassService) {
        LinkedHashSet<String> whiteList = new LinkedHashSet<String>();
        List<PersistentRelation> persistentRelations = persistentClass.getRelations();
        if (persistentRelations == null || persistentRelations.isEmpty()) {
            return whiteList;
        }
        Set<PersistentRelation> relations = persistentRelations.stream().filter(item -> item.getRelationType() == PersistentRelation.RelationType.ManyToMany || item.getRelationType() == PersistentRelation.RelationType.ManyToOne).collect(Collectors.toSet());
        this.fetchRelationsWhiteList(relations, persistentClass, whiteList, null);
        return whiteList;
    }

    protected Set<String> buildAllWhiteProperties(PersistentClass persistentClass, PersistentClassService persistentClassService) {
        LinkedHashSet<String> whiteList = new LinkedHashSet<String>();
        List<PersistentRelation> persistentRelations = persistentClass.getRelations();
        if (persistentRelations == null || persistentRelations.isEmpty()) {
            return whiteList;
        }
        Set<PersistentRelation> relations = persistentRelations.stream().filter(item -> item.getRelationType() == PersistentRelation.RelationType.ManyToMany || item.getRelationType() == PersistentRelation.RelationType.ManyToOne).collect(Collectors.toSet());
        this.fetchRelationsWhiteList(relations, persistentClass, whiteList, null);
        Set<PersistentRelation> itemsRelations = persistentRelations.stream().filter(item -> item.getRelationType() == PersistentRelation.RelationType.OneToMany).collect(Collectors.toSet());
        this.fetchItemsWhiteList(itemsRelations, persistentClass, persistentClassService, whiteList, null);
        Set<PersistentRelation> groupsRelations = persistentRelations.stream().filter(item -> item.getRelationType() == PersistentRelation.RelationType.OneToOne).collect(Collectors.toSet());
        this.fetchGroupsWhiteList(groupsRelations, persistentClass, persistentClassService, whiteList, null);
        return whiteList;
    }

    private void fetchRelationsWhiteList(Set<PersistentRelation> relations, PersistentClass parentClass, Set<String> whiteList, String lastName) {
        if (relations == null || relations.isEmpty()) {
            return;
        }
        String persistentClassName = parentClass.getClassName();
        for (PersistentRelation relationItem : relations) {
            String propertyClass = relationItem.getPropertyClass();
            String propertyName = relationItem.getPropertyName();
            if (StringUtils.equals((CharSequence)persistentClassName, (CharSequence)propertyClass)) continue;
            String currentWhiteName = this.buildCurrentWhiteName(lastName, propertyName);
            whiteList.add(currentWhiteName);
        }
    }

    private void fetchItemsWhiteList(Set<PersistentRelation> items, PersistentClass parentClass, PersistentClassService persistentClassService, Set<String> whiteList, String lastName) {
        if (items == null || items.isEmpty()) {
            return;
        }
        for (PersistentRelation item : items) {
            Set<PersistentRelation> itemOfRelationSets;
            String currentName = item.getPropertyName();
            String propertyClassName = item.getPropertyClass();
            if (StringUtils.equals((CharSequence)propertyClassName, (CharSequence)parentClass.getClassName())) continue;
            String currentWhiteName = this.buildCurrentWhiteName(lastName, currentName);
            whiteList.add(currentWhiteName);
            PersistentClass propertyClass = persistentClassService.queryByClassName(propertyClassName);
            Validate.notNull((Object)propertyClass, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u6a21\u578b\u7c7b\u63cf\u8ff0\uff0c\u8bf7\u68c0\u67e5\u626b\u63cf\u9879\u914d\u7f6e!!", (Object[])new Object[0]);
            List<PersistentRelation> itemOfRelations = propertyClass.getRelations();
            if (itemOfRelations == null || itemOfRelations.isEmpty() || (itemOfRelationSets = itemOfRelations.stream().filter(t -> t.getRelationType() == PersistentRelation.RelationType.ManyToMany || t.getRelationType() == PersistentRelation.RelationType.ManyToOne).collect(Collectors.toSet())) == null || itemOfRelationSets.isEmpty()) continue;
            this.fetchRelationsWhiteList(itemOfRelationSets, parentClass, whiteList, currentWhiteName);
        }
    }

    private void fetchGroupsWhiteList(Set<PersistentRelation> groupRelations, PersistentClass parentClass, PersistentClassService persistentClassService, Set<String> whiteList, String lastName) {
        if (groupRelations == null || groupRelations.isEmpty()) {
            return;
        }
        for (PersistentRelation group : groupRelations) {
            Set<PersistentRelation> itemRelations;
            String currentName = group.getPropertyName();
            String propertyClassName = group.getPropertyClass();
            if (StringUtils.equals((CharSequence)propertyClassName, (CharSequence)parentClass.getClassName())) continue;
            String currentWhiteName = this.buildCurrentWhiteName(lastName, currentName);
            whiteList.add(currentWhiteName);
            PersistentClass propertyClass = persistentClassService.queryByClassName(propertyClassName);
            Validate.notNull((Object)propertyClass, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u6a21\u578b\u7c7b\u63cf\u8ff0\uff0c\u8bf7\u68c0\u67e5\u626b\u63cf\u9879\u914d\u7f6e!!", (Object[])new Object[0]);
            List<PersistentRelation> groupOfRelations = propertyClass.getRelations();
            Set<PersistentRelation> relations = groupOfRelations.stream().filter(item -> item.getRelationType() == PersistentRelation.RelationType.ManyToMany || item.getRelationType() == PersistentRelation.RelationType.ManyToOne).collect(Collectors.toSet());
            if (relations != null && !relations.isEmpty()) {
                this.fetchRelationsWhiteList(relations, parentClass, whiteList, currentWhiteName);
            }
            if ((itemRelations = groupOfRelations.stream().filter(item -> item.getRelationType() == PersistentRelation.RelationType.OneToMany).collect(Collectors.toSet())) == null || itemRelations.isEmpty()) continue;
            this.fetchItemsWhiteList(itemRelations, propertyClass, persistentClassService, whiteList, currentWhiteName);
        }
    }

    private String buildCurrentWhiteName(String lastName, String currentName) {
        return StringUtils.isBlank((CharSequence)lastName) ? currentName : lastName + "." + currentName;
    }

    private static byte[] getUTF8BytesFromGBKString(String gbkStr) {
        int n = gbkStr.length();
        byte[] utfBytes = new byte[3 * n];
        int k = 0;
        for (int i = 0; i < n; ++i) {
            char m = gbkStr.charAt(i);
            if (m < '\u0080' && m >= '\u0000') {
                utfBytes[k++] = (byte)m;
                continue;
            }
            utfBytes[k++] = (byte)(0xE0 | m >> 12);
            utfBytes[k++] = (byte)(0x80 | m >> 6 & 0x3F);
            utfBytes[k++] = (byte)(0x80 | m & 0x3F);
        }
        if (k < utfBytes.length) {
            byte[] tmp = new byte[k];
            System.arraycopy(utfBytes, 0, tmp, 0, k);
            return tmp;
        }
        return utfBytes;
    }
}

