/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.saturn.scan;

import com.bizunited.platform.saturn.engine.annotation.BuildCustomRepository;
import com.bizunited.platform.saturn.engine.annotation.SaturnDomain;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnQueryMethod;
import com.bizunited.platform.saturn.engine.annotation.SaturnUpdateMethod;
import com.bizunited.platform.saturn.model.PersistentClass;
import com.bizunited.platform.saturn.model.PersistentProperty;
import com.bizunited.platform.saturn.model.PersistentQueryMethod;
import com.bizunited.platform.saturn.model.PersistentRelation;
import com.bizunited.platform.saturn.model.PersistentUpdateMethod;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javassist.CtClass;
import javassist.CtField;
import javassist.NotFoundException;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JavassistAnalysis {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavassistAnalysis.class);
    private static final String[] RETAINFIELDNAMES = new String[]{"select", "from", "in", "exists", "order", "by", "status", "group", "left", "join", "right", "fetch", "inner", "not", "table", "delete", "update", "insert"};

    public PersistentClass analyze(CtClass currentCtClass, List<PersistentProperty> properties, List<PersistentRelation> relations, boolean isChildPersistent) {
        CtField[] fields;
        if (currentCtClass == null) {
            return null;
        }
        PersistentClass prsistentClass = null;
        if (!isChildPersistent) {
            prsistentClass = new PersistentClass();
        }
        boolean hasEntityAnnotation = currentCtClass.hasAnnotation(Entity.class);
        boolean hasTableAnnotation = currentCtClass.hasAnnotation(Table.class);
        boolean hasSaturnEntityAnnotation = currentCtClass.hasAnnotation(SaturnEntity.class);
        boolean hasSaturnDomainAnnotation = currentCtClass.hasAnnotation(SaturnDomain.class);
        if (!(hasEntityAnnotation || hasSaturnEntityAnnotation || isChildPersistent)) {
            return null;
        }
        if (properties == null) {
            properties = new LinkedList<PersistentProperty>();
        }
        if (relations == null) {
            relations = new LinkedList<PersistentRelation>();
        }
        CtClass superClass = null;
        try {
            superClass = currentCtClass.getSuperclass();
        }
        catch (NotFoundException e) {
            LOGGER.warn(e.getMessage());
        }
        if (superClass != null) {
            this.analyze(superClass, properties, relations, true);
        }
        String className = currentCtClass.getName();
        if (prsistentClass != null) {
            String pkage = currentCtClass.getPackageName();
            String simpleName = currentCtClass.getSimpleName();
            boolean hasBuildCustomRepositoryAnnotation = currentCtClass.hasAnnotation(BuildCustomRepository.class);
            String domain = "";
            if (hasSaturnDomainAnnotation) {
                try {
                    SaturnDomain saturnDomain = (SaturnDomain)currentCtClass.getAnnotation(SaturnDomain.class);
                    domain = saturnDomain.value();
                }
                catch (Exception e) {
                    domain = "";
                }
                Pattern pattern = Pattern.compile("^[a-z]{1}[a-z|_|0-9]+$");
                boolean find = pattern.matcher(domain).find();
                Validate.isTrue((boolean)find, (String)"domain\u4fe1\u606f\u7531\u4e8e\u9700\u8981\u4f5c\u4e3a\u5305\u540d\uff0c\u6240\u4ee5\u6587\u5b57\u53ea\u80fd\u662f\u5c0f\u5199\uff0c\u4e14\u5fc5\u987b\u6ee1\u8db3java package\u7684\u547d\u540d\u89c4\u5219[%s]", (Object[])new Object[]{simpleName});
            }
            prsistentClass.setRepositoryEntity(hasEntityAnnotation);
            prsistentClass.setBuildCustomRepository(hasBuildCustomRepositoryAnnotation);
            prsistentClass.setSimpleClassName(simpleName);
            prsistentClass.setClassName(className);
            prsistentClass.setDomain(domain);
            prsistentClass.setPkage(pkage);
            if (hasEntityAnnotation && hasTableAnnotation) {
                try {
                    Table tableAnnotation = (Table)currentCtClass.getAnnotation(Table.class);
                    prsistentClass.setRepositoryEntity(true);
                    prsistentClass.setRepositoryTable(tableAnnotation.name());
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            } else if (hasEntityAnnotation && !hasTableAnnotation) {
                prsistentClass.setRepositoryEntity(true);
                prsistentClass.setRepositoryTable(null);
            } else {
                prsistentClass.setRepositoryEntity(false);
                prsistentClass.setRepositoryTable(null);
            }
        }
        if ((fields = currentCtClass.getDeclaredFields()) == null || fields.length == 0) {
            return prsistentClass;
        }
        int fieldIndex = 0;
        for (CtField fieldItem : fields) {
            String fieldName = fieldItem.getName();
            Arrays.stream(RETAINFIELDNAMES).forEach(item -> Validate.isTrue((!StringUtils.equalsIgnoreCase((CharSequence)item, (CharSequence)fieldName) ? 1 : 0) != 0, (String)"\u5728\u626b\u63cf\u68c0\u67e5%s\u65f6\u53d1\u73b0\u4fdd\u7559\u5b57\uff1a%s\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{currentCtClass.getName(), fieldName}));
            Validate.isTrue((StringUtils.indexOf((CharSequence)fieldName, (CharSequence)"_") == -1 ? 1 : 0) != 0, (String)"\u5728\u626b\u63cf\u68c0\u67e5%s\u65f6\u53d1\u73b0\u201c_\u201d\uff0c\u8be5\u5b57\u7b26\u4e3a\u4fdd\u7559\u5b57\u7b26\u4e0d\u5141\u8bb8\u5728\u5b57\u6bb5\u5b9a\u4e49\u65f6\u4f7f\u7528\uff1a%s\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{currentCtClass.getName(), fieldName});
            PersistentProperty persistentProperty = this.analysisGeneralField(fieldItem, ++fieldIndex);
            if (persistentProperty == null) continue;
            persistentProperty.setPersistentClassName(className);
            properties.add(persistentProperty);
        }
        if (prsistentClass != null) {
            prsistentClass.setProperties(properties);
        }
        fieldIndex = 0;
        Class<?> reflectClass = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            reflectClass = Class.forName(className, false, classLoader);
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn(e.getMessage());
            return null;
        }
        for (CtField fieldItem : fields) {
            String fieldName = fieldItem.getName();
            Arrays.stream(RETAINFIELDNAMES).forEach(item -> Validate.isTrue((!StringUtils.equalsIgnoreCase((CharSequence)item, (CharSequence)fieldName) ? 1 : 0) != 0, (String)"\u5728\u626b\u63cf\u68c0\u67e5%s\u65f6\u53d1\u73b0\u4fdd\u7559\u5b57\uff1a%s\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{currentCtClass.getName(), fieldName}));
            LOGGER.debug("fieldName == " + fieldName);
            PersistentRelation relation = this.analysisRelationField(reflectClass, fieldItem, ++fieldIndex);
            if (relation == null) continue;
            relation.setPersistentClassName(className);
            relations.add(relation);
        }
        if (prsistentClass != null) {
            prsistentClass.setRelations(relations);
        }
        return prsistentClass;
    }

    protected abstract PersistentProperty analysisGeneralField(CtField var1, int var2);

    protected abstract PersistentRelation analysisRelationField(Class<?> var1, CtField var2, int var3);

    public PersistentUpdateMethod analysisUpdateMethod(PersistentClass prsistentClass, SaturnUpdateMethod saturnUpdateMethod) {
        PersistentUpdateMethod persistentUpdateMethod = new PersistentUpdateMethod();
        String className = prsistentClass.getClassName();
        String description = saturnUpdateMethod.description();
        Validate.notBlank((CharSequence)description, (String)"\u81ea\u5b9a\u4e49\u4fee\u6539\u65b9\u6cd5\u4e2d\u7684\u63cf\u8ff0\u4fe1\u606f\u5fc5\u987b\u6307\u5b9a[%s:UpdateMethod]!", (Object[])new Object[]{className});
        persistentUpdateMethod.setDescription(description);
        persistentUpdateMethod.setPersistentClassName(className);
        String methodName = saturnUpdateMethod.methodName();
        Validate.isTrue((boolean)StringUtils.startsWithAny((CharSequence)methodName, (CharSequence[])new CharSequence[]{"update"}), (String)"\u81ea\u5b9a\u4e49\u66f4\u65b0\u65b9\u6cd5\u53ea\u80fd\u4ee5update\u5173\u952e\u5b57\u5f00\u59cb!!", (Object[])new Object[0]);
        persistentUpdateMethod.setMethodName(methodName);
        String[] queryFields = saturnUpdateMethod.queryParams();
        Validate.isTrue((queryFields != null && queryFields.length > 0 ? 1 : 0) != 0, (String)"\u5fc5\u987b\u8bbe\u5b9a\u66f4\u65b0\u65b9\u6cd5\u7684\u67e5\u8be2\u6761\u4ef6\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        List<PersistentProperty> persistentPropertys = prsistentClass.getProperties();
        Map<String, PersistentProperty> persistentPropertyMapping = persistentPropertys.stream().collect(Collectors.toMap(PersistentProperty::getPropertyName, persistentProperty -> persistentProperty));
        for (String queryFieldItem : queryFields) {
            Validate.isTrue((StringUtils.indexOf((CharSequence)queryFieldItem, (int)46) == -1 ? 1 : 0) != 0, (String)"\u67e5\u8be2\u6761\u4ef6\u4e0d\u652f\u6301\u5173\u8054\u7279\u6027\u201c.\u201d", (Object[])new Object[0]);
            PersistentProperty persistentProperty2 = persistentPropertyMapping.get(queryFieldItem);
            Validate.notNull((Object)persistentProperty2, (String)"\u672a\u53d1\u73b0\u67e5\u8be2\u6761\u4ef6\u914d\u7f6e\u4e2d\u6307\u5b9a\u7684\u5c5e\u6027%s\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[]{queryFieldItem});
        }
        persistentUpdateMethod.setQueryParams(queryFields);
        String[] updateFields = saturnUpdateMethod.updateParams();
        Validate.isTrue((updateFields != null && updateFields.length > 0 ? 1 : 0) != 0, (String)"\u5fc5\u987b\u8bbe\u5b9a\u66f4\u65b0\u65b9\u6cd5\u7684\u66f4\u65b0\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        for (String updateFieldItem : updateFields) {
            Validate.isTrue((StringUtils.indexOf((CharSequence)updateFieldItem, (int)46) == -1 ? 1 : 0) != 0, (String)"\u66f4\u65b0\u5b57\u6bb5\u4e0d\u652f\u6301\u5173\u8054\u7279\u6027\u201c.\u201d", (Object[])new Object[0]);
            PersistentProperty persistentProperty3 = persistentPropertyMapping.get(updateFieldItem);
            Validate.notNull((Object)persistentProperty3, (String)"\u672a\u53d1\u73b0\u66f4\u65b0\u5b57\u6bb5\u914d\u7f6e\u4e2d\u6307\u5b9a\u7684\u5c5e\u6027%s\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[]{updateFieldItem});
        }
        persistentUpdateMethod.setUpdateParams(updateFields);
        return persistentUpdateMethod;
    }

    private PersistentProperty foundRelationParms(PersistentClass prsistentClass, String[] paramArrayItems, int itemIndex, Map<String, PersistentClass> persistentClassMapping) {
        Validate.notNull((Object)prsistentClass, (String)"\u6ca1\u6709\u627e\u5230\u6a21\u578b\u7ed3\u6784\u63cf\u8ff0!!", (Object[])new Object[0]);
        Validate.isTrue((paramArrayItems != null && paramArrayItems.length > 0 ? 1 : 0) != 0, (String)"\u6ca1\u6709\u627e\u5230\u6a21\u578b\u7ed3\u6784\u4e2d\u7684\u6307\u5b9a\u5c5e\u6027!!", (Object[])new Object[0]);
        List<PersistentProperty> persistentPropertys = prsistentClass.getProperties();
        Validate.isTrue((persistentPropertys != null && !persistentPropertys.isEmpty() ? 1 : 0) != 0, (String)"\u6ca1\u6709\u627e\u5230\u6a21\u578b\u7ed3\u6784\u4e2d\u7684\u6307\u5b9a\u5c5e\u6027!!", (Object[])new Object[0]);
        List<PersistentRelation> persistentRelations = prsistentClass.getRelations();
        Validate.isTrue((persistentRelations != null && !persistentRelations.isEmpty() ? 1 : 0) != 0, (String)"\u6ca1\u6709\u627e\u5230\u6a21\u578b\u7ed3\u6784\u4e2d\u7684\u6307\u5b9a\u5c5e\u6027!!", (Object[])new Object[0]);
        Map<String, PersistentProperty> persistentPropertyMapping = persistentPropertys.stream().collect(Collectors.toMap(PersistentProperty::getPropertyName, persistentProperty -> persistentProperty));
        Map<String, PersistentRelation> persistentRelationMapping = persistentRelations.stream().collect(Collectors.toMap(PersistentRelation::getPropertyName, persistentRelation -> persistentRelation));
        String currentParamItem = paramArrayItems[itemIndex];
        PersistentProperty currentPersistentProperty = null;
        PersistentProperty persistentProperty2 = persistentPropertyMapping.get(currentParamItem);
        if (persistentProperty2 != null) {
            currentPersistentProperty = persistentProperty2;
            Validate.isTrue((itemIndex + 1 == paramArrayItems.length ? 1 : 0) != 0, (String)"\u6ca1\u6709\u627e\u5230\u6a21\u578b\u7ed3\u6784\u4e2d\u7684\u6307\u5b9a\u5c5e\u6027!!", (Object[])new Object[0]);
        } else {
            PersistentRelation persistentRelation2 = persistentRelationMapping.get(currentParamItem);
            Validate.notNull((Object)persistentRelation2, (String)"\u6ca1\u6709\u627e\u5230\u6a21\u578b\u7ed3\u6784\u4e2d\u7684\u6307\u5b9a\u5c5e\u6027!!", (Object[])new Object[0]);
            if (itemIndex + 1 < paramArrayItems.length) {
                String propertyClass = persistentRelation2.getPropertyClass();
                PersistentClass nextPersistentClass = persistentClassMapping.get(propertyClass);
                Validate.notNull((Object)nextPersistentClass, (String)"\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u6a21\u578b\u7ed3\u6784(\u4e00\u65e6\u51fa\u73b0\u8fd9\u4e2a\u9519\u8bef\uff0c\u53ef\u80fd\u662f\u4e4b\u524d\u7b2c\u4e00\u6b21\u6a21\u578b\u626b\u63cf\u51fa\u73b0\u4e86bug\uff0c\u8bf7\u8054\u7cfb\u7a0b\u5e8f\u5458)!!", (Object[])new Object[0]);
                currentPersistentProperty = this.foundRelationParms(nextPersistentClass, paramArrayItems, itemIndex + 1, persistentClassMapping);
            } else if (itemIndex + 1 == paramArrayItems.length) {
                throw new IllegalArgumentException("\u6839\u636e\u914d\u7f6e\u8981\u6c42\uff0c\u6700\u540e\u4e00\u7ea7\u5c5e\u6027\u5fc5\u987b\u662f\u4e00\u822c\u7c7b\u578b\u7684\u5c5e\u6027\uff0c\u8bf7\u68c0\u67e5\u67e5\u8be2\u5b57\u6bb5\u7684\u914d\u7f6e!!");
            }
        }
        return currentPersistentProperty;
    }

    public PersistentQueryMethod analysisQueryMethod(PersistentClass prsistentClass, SaturnQueryMethod queryMethodAnnotation, Map<String, PersistentClass> persistentClassMapping) {
        PersistentQueryMethod persistentQueryMethod = new PersistentQueryMethod();
        String className = prsistentClass.getClassName();
        persistentQueryMethod.setPersistentClassName(className);
        String description = queryMethodAnnotation.description();
        Validate.notBlank((CharSequence)description, (String)"\u81ea\u5b9a\u4e49\u67e5\u8be2\u65b9\u6cd5\u4e2d\u7684\u63cf\u8ff0\u4fe1\u606f\u5fc5\u987b\u6307\u5b9a[%s:QueryMethod]!", (Object[])new Object[]{className});
        persistentQueryMethod.setDescription(description);
        String methodName = queryMethodAnnotation.methodName();
        Validate.isTrue((boolean)StringUtils.startsWithAny((CharSequence)methodName, (CharSequence[])new CharSequence[]{"query", "find"}), (String)"\u81ea\u5b9a\u4e49\u67e5\u8be2\u65b9\u6cd5\u53ea\u80fd\u4ee5query\u6216\u8005find\u5f00\u59cb!!", (Object[])new Object[0]);
        persistentQueryMethod.setMethodName(methodName);
        String[] params = queryMethodAnnotation.params();
        if (params == null || params.length == 0) {
            return null;
        }
        for (String param : params) {
            String[] paramArrayItems = StringUtils.split((String)param, (String)".");
            String[] persistentProperty2 = this.foundRelationParms(prsistentClass, paramArrayItems, 0, persistentClassMapping);
            Validate.notNull((Object)persistentProperty2, (String)"\u6ca1\u6709\u53d1\u73b0\u81ea\u5b9a\u4e49\u67e5\u8be2\u4e2d\u7684\u5c5e\u6027\uff0c\u6216\u8005\u5c5e\u6027\u4e0d\u7b26\u5408\u914d\u7f6e\u8981\u6c42\uff1a[%s]", (Object[])new Object[]{param});
        }
        persistentQueryMethod.setParams(params);
        SaturnQueryMethod.QueryType[] queryTypeAnnotations = queryMethodAnnotation.queryType();
        PersistentQueryMethod.QueryType[] currentQueryTypes = new PersistentQueryMethod.QueryType[params.length];
        Arrays.fill((Object[])currentQueryTypes, (Object)PersistentQueryMethod.QueryType.EQUAL);
        for (int index = 0; queryTypeAnnotations != null && index < queryTypeAnnotations.length && index < params.length; ++index) {
            SaturnQueryMethod.QueryType queryTypeItem = queryTypeAnnotations[index];
            String param = params[index];
            Validate.notBlank((CharSequence)param, (String)"\u67e5\u8be2\u5b57\u6bb5\u4fe1\u606f\u4e0d\u80fd\u4e3anull\uff0c\u6216\u8005\u7a7a\u5b57\u7b26\u4e32\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            currentQueryTypes[index] = queryTypeItem == SaturnQueryMethod.QueryType.BETWEEN ? PersistentQueryMethod.QueryType.BETWEEN : (queryTypeItem == SaturnQueryMethod.QueryType.EQUAL ? PersistentQueryMethod.QueryType.EQUAL : (queryTypeItem == SaturnQueryMethod.QueryType.GREATEREQUALTHAN ? PersistentQueryMethod.QueryType.GREATEREQUALTHAN : (queryTypeItem == SaturnQueryMethod.QueryType.GREATERTHAN ? PersistentQueryMethod.QueryType.GREATERTHAN : (queryTypeItem == SaturnQueryMethod.QueryType.LESSEQUALTHAN ? PersistentQueryMethod.QueryType.LESSEQUALTHAN : (queryTypeItem == SaturnQueryMethod.QueryType.LESSTHAN ? PersistentQueryMethod.QueryType.LESSTHAN : PersistentQueryMethod.QueryType.EQUAL)))));
        }
        persistentQueryMethod.setQueryTypes(currentQueryTypes);
        String[] orderParams = null;
        try {
            orderParams = queryMethodAnnotation.orderByParams();
        }
        catch (Exception e) {
            orderParams = null;
        }
        if (orderParams == null || orderParams.length == 0 || orderParams.length == 1 && StringUtils.equals((CharSequence)"", (CharSequence)orderParams[0])) {
            return persistentQueryMethod;
        }
        List<PersistentProperty> persistentPropertys = prsistentClass.getProperties();
        Map<String, PersistentProperty> persistentPropertyMapping = persistentPropertys.stream().collect(Collectors.toMap(PersistentProperty::getPropertyName, persistentProperty -> persistentProperty));
        for (String orderParamItem : orderParams) {
            Validate.isTrue((StringUtils.indexOf((CharSequence)orderParamItem, (int)46) == -1 ? 1 : 0) != 0, (String)"\u6392\u5e8f\u5c5e\u6027\u4e0d\u652f\u6301\u5173\u8054\u7279\u6027\u201c.\u201d", (Object[])new Object[0]);
            PersistentProperty persistentProperty3 = persistentPropertyMapping.get(orderParamItem);
            Validate.notNull((Object)persistentProperty3, (String)"\u672a\u53d1\u73b0\u6392\u5e8f\u914d\u7f6e\u4e2d\u6307\u5b9a\u7684\u5c5e\u6027%s\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[]{orderParamItem});
        }
        persistentQueryMethod.setOrderByParams(orderParams);
        SaturnQueryMethod.OrderType[] orderTypeAnnotations = new SaturnQueryMethod.OrderType[]{SaturnQueryMethod.OrderType.ASC};
        try {
            orderTypeAnnotations = queryMethodAnnotation.orderType();
        }
        catch (Exception e) {
            orderTypeAnnotations = new SaturnQueryMethod.OrderType[]{SaturnQueryMethod.OrderType.ASC};
        }
        PersistentQueryMethod.OrderType[] currentOrderTypes = new PersistentQueryMethod.OrderType[orderParams.length];
        Arrays.fill((Object[])currentOrderTypes, (Object)PersistentQueryMethod.OrderType.ASC);
        for (int index = 0; orderTypeAnnotations != null && index < orderTypeAnnotations.length && index < orderParams.length; ++index) {
            SaturnQueryMethod.OrderType orderTypeItem = orderTypeAnnotations[index];
            String orderParam = orderParams[index];
            Validate.notBlank((CharSequence)orderParam, (String)"\u6392\u5e8f\u5b57\u6bb5\u4fe1\u606f\u4e0d\u80fd\u4e3anull\uff0c\u6216\u8005\u7a7a\u5b57\u7b26\u4e32\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            currentOrderTypes[index] = orderTypeItem == SaturnQueryMethod.OrderType.ASC ? PersistentQueryMethod.OrderType.ASC : PersistentQueryMethod.OrderType.DESC;
        }
        persistentQueryMethod.setOrderTypes(currentOrderTypes);
        return persistentQueryMethod;
    }
}

