/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.saturn.scan;

import com.bizunited.platform.saturn.context.SaturnContext;
import com.bizunited.platform.saturn.engine.annotation.BuildQueryMethods;
import com.bizunited.platform.saturn.engine.annotation.BuildUpdateMethods;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnQueryMethod;
import com.bizunited.platform.saturn.engine.annotation.SaturnUpdateMethod;
import com.bizunited.platform.saturn.model.PersistentClass;
import com.bizunited.platform.saturn.model.PersistentQueryMethod;
import com.bizunited.platform.saturn.model.PersistentUpdateMethod;
import com.bizunited.platform.saturn.scan.ClassScanner;
import com.bizunited.platform.saturn.scan.JavassistAnalysis;
import com.bizunited.platform.saturn.scan.JpaTagJavassistAnalysis;
import com.bizunited.platform.saturn.scan.OwnerTagJavassistAnalysis;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javax.persistence.Entity;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleClassScanner
implements ClassScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleClassScanner.class);
    private static ClassPool classPool = ClassPool.getDefault();

    @Override
    public List<PersistentClass> handle(SaturnContext context) {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        classPool.appendClassPath((ClassPath)new LoaderClassPath(currentClassLoader));
        String[] rootScanPackages = context.getRootScanPackages();
        Validate.isTrue((rootScanPackages != null && rootScanPackages.length > 0 ? 1 : 0) != 0, (String)"\u8bf7\u4e3asaturn\u9aa8\u67b6\u5206\u6790\u5668\u6307\u5b9a\u626b\u63cf\u6a21\u578b\u5b9a\u4e49\u7684\u6839\u5305\u8def\u5f84\uff08\u81f3\u5c11\u6307\u5b9a\u4e00\u4e2a\uff09", (Object[])new Object[0]);
        List<PersistentClass> persistentClasses = this.scan(rootScanPackages);
        return persistentClasses;
    }

    private List<PersistentClass> scan(String[] rootPackages) {
        if (rootPackages == null || rootPackages.length == 0) {
            return null;
        }
        LinkedHashMap<String, PersistentClass> persistentClassMapping = new LinkedHashMap<String, PersistentClass>();
        LinkedHashMap<String, JavassistAnalysis> javassistAnalysisMapping = new LinkedHashMap<String, JavassistAnalysis>();
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        for (String rootPackage : rootPackages) {
            LOGGER.info("saturn\u9aa8\u67b6\u6b63\u5728\u626b\u63cf\u5de5\u7a0b\u8def\u5f84\uff1a" + rootPackage);
            String rootPackagePath = RegExUtils.replaceAll((String)rootPackage, (String)"\\.", (String)"/");
            Enumeration<URL> urls = null;
            try {
                urls = currentClassLoader.getResources(rootPackagePath);
            }
            catch (IOException e) {
                LOGGER.warn(e.getMessage());
                continue;
            }
            if (urls != null) {
                URL classUrl = null;
                try {
                    classUrl = urls.nextElement();
                    LOGGER.info("classUrl = " + classUrl);
                }
                catch (Exception e) {
                    LOGGER.warn("classUrl = " + e.getMessage());
                    continue;
                }
                String protocol = classUrl.getProtocol();
                if ("file".equals(protocol)) {
                    this.scanFileForFields(persistentClassMapping, javassistAnalysisMapping, classUrl.getPath(), rootPackage);
                } else if ("jar".equals(protocol)) {
                    this.scanJarForFields(persistentClassMapping, javassistAnalysisMapping, classUrl, rootPackagePath);
                }
            }
            LOGGER.info("new persistentClass = " + persistentClassMapping.size());
        }
        Collection persistentClasses = persistentClassMapping.values();
        for (PersistentClass persistentClass : persistentClasses) {
            CtClass currentCtClass;
            String className = persistentClass.getClassName();
            try {
                currentCtClass = classPool.get(className);
            }
            catch (NotFoundException e) {
                LOGGER.error(e.getMessage());
                throw new IllegalArgumentException(e.getMessage());
            }
            this.scanClassMethods(currentCtClass, persistentClass, persistentClassMapping, javassistAnalysisMapping);
        }
        return new LinkedList<PersistentClass>(persistentClassMapping.values());
    }

    private void scanJarForFields(Map<String, PersistentClass> persistentClassMapping, Map<String, JavassistAnalysis> javassistAnalysisMapping, URL jarUrl, String rootPackagePath) {
        JarFile jar;
        try {
            jar = ((JarURLConnection)jarUrl.openConnection()).getJarFile();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage());
            return;
        }
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            String jarEntryName = jarEntry.getName();
            if (!StringUtils.endsWith((CharSequence)jarEntryName, (CharSequence)".class") || StringUtils.contains((CharSequence)jarEntryName, (CharSequence)"$") || !StringUtils.startsWith((CharSequence)jarEntryName, (CharSequence)rootPackagePath)) continue;
            String classFullName = StringUtils.removeEnd((String)jarEntryName, (String)".class");
            classFullName = RegExUtils.replaceAll((String)classFullName, (String)"/", (String)".");
            CtClass currentCtClass = null;
            try {
                currentCtClass = classPool.get(classFullName);
            }
            catch (NotFoundException e) {
                LOGGER.warn(e.getMessage());
                continue;
            }
            boolean hasEntityAnnotation = currentCtClass.hasAnnotation(Entity.class);
            boolean hasSaturnEntityAnnotation = currentCtClass.hasAnnotation(SaturnEntity.class);
            PersistentClass persistentClass = null;
            JavassistAnalysis analysis = null;
            if (!hasEntityAnnotation && !hasSaturnEntityAnnotation) continue;
            if (hasEntityAnnotation) {
                analysis = new JpaTagJavassistAnalysis();
                persistentClass = analysis.analyze(currentCtClass, null, null, false);
            } else if (!hasEntityAnnotation && hasSaturnEntityAnnotation) {
                analysis = new OwnerTagJavassistAnalysis();
                persistentClass = analysis.analyze(currentCtClass, null, null, false);
            }
            if (persistentClass == null) continue;
            persistentClassMapping.put(classFullName, persistentClass);
            javassistAnalysisMapping.put(classFullName, analysis);
        }
    }

    private void scanFileForFields(Map<String, PersistentClass> persistentClassMapping, Map<String, JavassistAnalysis> javassistAnalysisMapping, String currentPackagePath, String currentPackageName) {
        File[] childfiles;
        File dir = new File(currentPackagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : childfiles = dir.listFiles(pathname -> pathname.isDirectory() || pathname.getName().endsWith(".class"))) {
            if (file.isDirectory()) {
                String childPackageName = file.getName();
                this.scanFileForFields(persistentClassMapping, javassistAnalysisMapping, file.getAbsolutePath(), currentPackageName + "." + childPackageName);
                continue;
            }
            String fileName = file.getName();
            LOGGER.debug("current fileName = " + fileName);
            if (!file.getName().endsWith(".class")) {
                return;
            }
            String fileSortName = StringUtils.removeEnd((String)fileName, (String)".class");
            CtClass currentCtClass = null;
            String classFullName = currentPackageName + "." + fileSortName;
            try {
                currentCtClass = classPool.get(classFullName);
            }
            catch (NotFoundException e) {
                LOGGER.error(e.getLocalizedMessage());
                continue;
            }
            boolean hasEntityAnnotation = currentCtClass.hasAnnotation(Entity.class);
            boolean hasSaturnEntityAnnotation = currentCtClass.hasAnnotation(SaturnEntity.class);
            PersistentClass persistentClass = null;
            JavassistAnalysis analysis = null;
            if (!hasEntityAnnotation && !hasSaturnEntityAnnotation) continue;
            if (hasEntityAnnotation) {
                analysis = new JpaTagJavassistAnalysis();
                persistentClass = analysis.analyze(currentCtClass, null, null, false);
            } else if (!hasEntityAnnotation && hasSaturnEntityAnnotation) {
                analysis = new OwnerTagJavassistAnalysis();
                persistentClass = analysis.analyze(currentCtClass, null, null, false);
            }
            if (persistentClass == null) continue;
            persistentClassMapping.put(classFullName, persistentClass);
            javassistAnalysisMapping.put(classFullName, analysis);
        }
    }

    private void scanClassMethods(CtClass currentCtClass, PersistentClass persistentClass, Map<String, PersistentClass> persistentClassMapping, Map<String, JavassistAnalysis> javassistAnalysisMapping) {
        boolean hasBuildQueryMethodsAnnotation = currentCtClass.hasAnnotation(BuildQueryMethods.class);
        String fullClassName = persistentClass.getClassName();
        LinkedList<PersistentQueryMethod> persistentQueryMethods = null;
        if (hasBuildQueryMethodsAnnotation) {
            Object[] methodsAnnotationObjects = null;
            try {
                methodsAnnotationObjects = currentCtClass.getAnnotations();
            }
            catch (ClassNotFoundException e) {
                LOGGER.error(e.getMessage());
                throw new IllegalArgumentException(e);
            }
            SaturnQueryMethod[] saturnQueryMethods = null;
            for (int index = 0; methodsAnnotationObjects != null && index < methodsAnnotationObjects.length; ++index) {
                SaturnQueryMethod[] annotationObject = methodsAnnotationObjects[index];
                if (!(annotationObject instanceof BuildQueryMethods)) continue;
                BuildQueryMethods buildQueryMethods = (BuildQueryMethods)annotationObject;
                saturnQueryMethods = buildQueryMethods.methods();
                break;
            }
            if (saturnQueryMethods != null) {
                persistentQueryMethods = new LinkedList<PersistentQueryMethod>();
                JavassistAnalysis currentAnalysis = javassistAnalysisMapping.get(fullClassName);
                Validate.notNull((Object)currentAnalysis, (String)("\u5982\u679c\u51fa\u73b0\u8be5\u9519\u8bef\u8bf4\u660e\u7a0b\u5e8f\u5de5\u4f5c\u5f02\u5e38\uff0c\u8bf7\u63d0\u4ea4patch(currentAnalysis is null[classname:" + fullClassName + "])"), (Object[])new Object[0]);
                for (SaturnQueryMethod saturnQueryMethod : saturnQueryMethods) {
                    PersistentQueryMethod persistentQueryMethod = currentAnalysis.analysisQueryMethod(persistentClass, saturnQueryMethod, persistentClassMapping);
                    if (persistentQueryMethod == null) continue;
                    persistentQueryMethods.add(persistentQueryMethod);
                }
            }
        }
        persistentClass.setQueryMethods(persistentQueryMethods);
        boolean hasBuildUpdateMethodsAnnotation = currentCtClass.hasAnnotation(BuildUpdateMethods.class);
        LinkedList<PersistentUpdateMethod> persistentUpdateMethods = null;
        if (hasBuildUpdateMethodsAnnotation) {
            Object[] methodsAnnotationObjects = null;
            try {
                methodsAnnotationObjects = currentCtClass.getAnnotations();
            }
            catch (ClassNotFoundException e) {
                LOGGER.error(e.getMessage());
                throw new IllegalArgumentException(e);
            }
            SaturnUpdateMethod[] saturnUpdateMethods = null;
            for (int index = 0; methodsAnnotationObjects != null && index < methodsAnnotationObjects.length; ++index) {
                Object annotationObject = methodsAnnotationObjects[index];
                if (!(annotationObject instanceof BuildUpdateMethods)) continue;
                BuildUpdateMethods buildUpdateMethods = (BuildUpdateMethods)annotationObject;
                saturnUpdateMethods = buildUpdateMethods.methods();
                break;
            }
            if (saturnUpdateMethods != null) {
                persistentUpdateMethods = new LinkedList<PersistentUpdateMethod>();
                JavassistAnalysis currentAnalysis = javassistAnalysisMapping.get(fullClassName);
                Validate.notNull((Object)currentAnalysis, (String)("\u5982\u679c\u51fa\u73b0\u8be5\u9519\u8bef\u8bf4\u660e\u7a0b\u5e8f\u5de5\u4f5c\u5f02\u5e38\uff0c\u8bf7\u63d0\u4ea4patch(currentAnalysis is null[classname:" + fullClassName + "])"), (Object[])new Object[0]);
                for (SaturnUpdateMethod saturnUpdateMethod : saturnUpdateMethods) {
                    PersistentUpdateMethod persistentUpdateMethod = currentAnalysis.analysisUpdateMethod(persistentClass, saturnUpdateMethod);
                    if (persistentUpdateMethod == null) continue;
                    persistentUpdateMethods.add(persistentUpdateMethod);
                }
            }
        }
        persistentClass.setUpdateMethods(persistentUpdateMethods);
    }
}

