package com.bizunited.platform.security.local.config;

import com.bizunited.platform.core.service.sms.SmsService;
import com.bizunited.platform.security.local.service.internal.CheckCodeServiceDefaultImpl;
import com.bizunited.platform.security.local.service.internal.SmsServiceAdapter;
import com.bizunited.platform.security.local.service.internal.ValidateCodeServiceDefaultImpl;
import com.bizunited.platform.security.sdk.service.ccode.CheckCodeService;
import com.bizunited.platform.security.sdk.service.vcode.ValidateCodeService;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 验证码和校验码以及涉及到鉴权基本服务的配置文件
 * @author yinwenjie
 */
@Configuration
public class SmsCodeConfig {
  /**
   * 默认的校验码实现方式（校验码的表达方式通常是一张图片）
   * @return
   */
  @Bean
  @ConditionalOnMissingBean(name="checkCodeService")
  public CheckCodeService getCheckCodeService() {
    return new CheckCodeServiceDefaultImpl();
  }
  
  /**
   * 默认的验证码实现方式（通常以短信、语音为载体）
   * @return
   */
  @Bean
  @ConditionalOnMissingBean(name="validateCodeService")
  public ValidateCodeService getValidateCodeService() {
    return new ValidateCodeServiceDefaultImpl();
  }
  
  /**
   * 默认的短信息发送方式定义，注意这里只是一个适配器，如果业务系统没有真实的短信发送功能的实现，是不能真正的发送短信的
   * @return
   */
  @Bean
  @ConditionalOnMissingBean(name="smsService")
  public SmsService getSmsService() {
    return new SmsServiceAdapter(); 
  }
}
