package com.bizunited.platform.security.local.config;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import com.bizunited.platform.common.event.RequestTenantInfoEventListener;
import com.bizunited.platform.security.local.notifier.TenantRequestEventListenerForSecurity;

/**
 * 经典登录模块所实现的租户获取方式
 * @author yinwenjie
 */
@Configuration
public class TenantRequestEventConfig {
  @ConditionalOnMissingBean
  @Bean
  public RequestTenantInfoEventListener getTenantRequestEventListener() {
    return new TenantRequestEventListenerForSecurity();
  }
}
