package com.bizunited.platform.security.local.service;

import javax.servlet.http.HttpServletRequest;

import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.web.authentication.WebAuthenticationDetails;

import com.bizunited.platform.security.sdk.vo.LoginDetails;

/**
 * 该服务在登录操作时，对用于表单对象进行描述，例如buildDetails方法中表单的意思就是说</br>
 * 一旦用户进行登录，则使用一个LoginDetails类的对象，对这个登录表单进行描述
 * @author yinwenjie
 */
public class SimpleAuthenticationDetailsSource implements AuthenticationDetailsSource<HttpServletRequest, WebAuthenticationDetails> {
  
  @Override
  public WebAuthenticationDetails buildDetails(HttpServletRequest context) {
    return new LoginDetails(context);
  }
}
