package com.bizunited.platform.security.local.service.handle;

import com.bizunited.platform.common.controller.model.ResponseCode;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.security.sdk.config.SimpleSecurityProperties;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.stereotype.Component;

import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Date;

/**
 * 登出成功后，触发该handle</br>
 * 用于登出系统，并按照设定信息，跳转到指定的登陆后页面。所谓登录实际上就是清楚当前系统的cookies信息
 * @author yinwenjie
 *
 */
@Component("simpleLogoutSuccessHandler")
public class SimpleLogoutSuccessHandler implements LogoutSuccessHandler, HandleOutPut {

  @Autowired
  private SimpleSecurityProperties simpleSecurityProperties;

  @Override
  public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
    String username = "";
    if(authentication != null) {
      username = authentication.getName();
    }
    /*
     * 做两件事情：
     * 1、清除相关的cookes
     * 2、向前端调用者返回登出成功的提示信息
     * */
    Cookie[] allCookies = request.getCookies();
    if(allCookies != null) {
      for(int index = 0 ; index < allCookies.length ; index++){
        Cookie currentCookie = allCookies[index];
        currentCookie.setMaxAge(0);
        response.addCookie(currentCookie);
      }
    }
    
    ResponseModel result = new ResponseModel(new Date().getTime(), username, ResponseCode.E0, null);
    result.setSuccess(true);
    result.setMessage(simpleSecurityProperties.getLogoutSuccessRedirect());
    this.writeResponse(response, result);
  }
}
