package com.bizunited.platform.security.sdk.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 有nebula 2.4+版本开始提供的经典登录权限认证的配置信息</br>
 * 该模块只依赖nebula的另外三个模块（不存在循环依赖） nebula.user->nebula.rbac->nebula.core</br>
 * 您可以根据实际情况，替换掉该模块（自行实现登录功能）。
 * @author yinwenjie
 */
@Component
@ConfigurationProperties(prefix = "security")
public class SimpleSecurityProperties {
  /**
   * 忽略权限判断的url（且不参与tenantCode的过滤和appCode的过滤）
   */
  private String[] ignoreUrls;
  /**
   * 忽略权限判断url（但是要参与tenantCode过滤）
   */
  private String[] ignoreUrlsButFilterTenantCode;
  /**
   * 忽略权限判断的url（但是要参与appCode过滤）
   */
  private String[] ignoreUrlsButFilterAppCode;
  /**
   * 登录操作地址
   */
  private String loginUrl;
  /**
   * 登录成功跳转页面
   */
  private String loginPageUrl;
  /**
   * 登出操作地址
   */
  private String logoutUrl;
  /**
   * 登出成功后跳转页面
   */
  private String logoutSuccessRedirect = "";
  /**
   * 如果当前登录信息中，登录方式缺失，则使用该默认值（默认为1）
   */
  private int defaultLoginType = 1;
  /**
   * 那些系统默认存在的，需要忽略权限判定的地址
   */
  public static final String[] DEFAULT_IGNOREURLS = new String[] {"/default/**","/static/**"};
  
  public String[] getIgnoreUrls() {
    return ignoreUrls;
  }
  public void setIgnoreUrls(String[] ignoreUrls) {
    this.ignoreUrls = ignoreUrls;
  }
  public String[] getIgnoreUrlsButFilterTenantCode() {
    return ignoreUrlsButFilterTenantCode;
  }
  public void setIgnoreUrlsButFilterTenantCode(String[] ignoreUrlsButFilterTenantCode) {
    this.ignoreUrlsButFilterTenantCode = ignoreUrlsButFilterTenantCode;
  }
  public String[] getIgnoreUrlsButFilterAppCode() {
    return ignoreUrlsButFilterAppCode;
  }
  public void setIgnoreUrlsButFilterAppCode(String[] ignoreUrlsButFilterAppCode) {
    this.ignoreUrlsButFilterAppCode = ignoreUrlsButFilterAppCode;
  }
  public String getLoginUrl() {
    return loginUrl;
  }
  public void setLoginUrl(String loginUrl) {
    this.loginUrl = loginUrl;
  }
  public String getLoginPageUrl() {
    return loginPageUrl;
  }
  public void setLoginPageUrl(String loginPageUrl) {
    this.loginPageUrl = loginPageUrl;
  }
  public String getLogoutUrl() {
    return logoutUrl;
  }
  public void setLogoutUrl(String logoutUrl) {
    this.logoutUrl = logoutUrl;
  }
  public String getLogoutSuccessRedirect() {
    return logoutSuccessRedirect;
  }
  public void setLogoutSuccessRedirect(String logoutSuccessRedirect) {
    this.logoutSuccessRedirect = logoutSuccessRedirect;
  }
  public int getDefaultLoginType() {
    return defaultLoginType;
  }
  public void setDefaultLoginType(int defaultLoginType) {
    this.defaultLoginType = defaultLoginType;
  }
}
