package com.bizunited.platform.security.sdk.event;

import org.springframework.security.core.Authentication;

import com.bizunited.platform.security.sdk.vo.LoginDetails;

/**
 * spring security被nebula封装以后，需要向上层模块暴露相关的事件监听。这里的事件为鉴权后会被触发的事件
 * @author yinwenjie
 */
public interface AuthenticatedEventListener {
  /**
   * 当本次登录鉴权过程中，鉴权成功时，该事件被促发
   * @param loginDetails 由于登录成功，所以作为入参的loginDetails，是会进行完善的。
   * @param authentication 鉴权成功后的用户账号信息、绑定的角色信息，都在该参数中
   */
  void onAuthenticationSuccess(LoginDetails loginDetails , Authentication authentication);
  /**
   * 当本次登录鉴权过程中，鉴权失败时，该事件被触发</br>
   * @param loginDetails 注意由于鉴权失败，所以作为入参的loginDetails不会进行完善（也就是说不一定有account信息），当时登录时携带了哪些参数，这里就只有哪些参数
   */
  void onAuthenticationFailed(LoginDetails loginDetails);
}