package com.bizunited.platform.security.sdk.event;

import com.bizunited.platform.security.sdk.vo.LoginDetails;

/**
 * 鉴权决策器，目前支持六种。当验证过程发生时，该策略被触发
 * @author yinwenjie
 */
public interface AuthenticationDecisionStrategy {
  String ERROR_USER = "没有发现指定的用户，或者用户已经被禁用，也可能是密码已经失效！！";
  String ERROR_SMS_CODE = "用户输入的验证码错误，或已失效，请检查（重发）！！";
  String ERROR_CHECK_CODE = "用户输入的图形校验码错误，或已失效，请检查！！";
  /**
   * 用户登录信息验证器。在具体的验证器中技术人员将尽可能的完善loginDetails信息。
   * 特别是其中的tenantCode信息和account信息必须得到完善
   * @param loginDetails 当前登录的用户信息 
   * @return 如果验证成功，则返回true；其它情况返回false，或者直接抛出异常
   */
  public boolean onAuthenticate(LoginDetails loginDetails);
  
  /**
   * 该方法返回当前实现的对应的认证类型：</br>
   * 1、典型的用户名+密码方式；</br>
   * 2、典型的用户名 + 密码 + 校验码方式；</br>
   * 3、用户名 + 短信验证码 + 校验码方式；</br> 
   * 4、手机号 + 密码方式；</br>
   * 5、手机号 + 短信验证码；</br>
   * 6、手机号 + 短信验证码 + 校验码方式</p> 
   * 当然，还可以自己给定登录方式的代码
   */
  public DecisionTypes type();
}
