package com.bizunited.platform.security.sdk.event;

import java.util.List;
import java.util.Set;

import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

/**
 * spring security被nebula封装以后，需要向上层模块暴露相关的事件监听。这里的事件一般为要求系统中的RBAC模块进行订阅的事件</br>
 * 以便在鉴权过程中、鉴权成功/鉴权失败后，向上层业务模块触发相关事件，进行关键信息获取或者驱动上层模块完成处理逻辑
 * @author yinwenjie
 */
public interface AuthenticationRbacEventListener {
  /**
   * 当nebula-security组件对某个HTTP请求进行权限认证，需要获取当前HTTP请求所对应的角色（roleCode）时，该事件被触发</br>
   * 注意，如果当前请求已设置为不需要验证，又或者当前登陆者具备管理员角色，该方法都不会触发。
   * @param matchedRequestMappings 当前本次HTTP请求，所满足的可使用的请求处理器（一般只有一个，但不排除有多个）
   * @param tenantCode 当次请求的二级租户信息（一定有值）
   * @param currentMethod 当前请求的Method Type信息，例如“POST”、“GET”等等。
   * @return 返回的角色业务编号信息，将用于鉴权工作后续的功能
   */
  Set<String> onRequestRoleCodes(List<RequestMappingInfo> matchedRequestMappings , String tenantCode , String currentMethod);
  /**
   * 当nebula-security组件需要获取当前系统设计的“管理员角色”清单时，该事件被触发</br>
   * 管理员角色清单可能来源于上层模块的配置清单，也可能来源于上层模块的数据库信息。
   * @return 如果返回null或者空集合，则表示当前系统没有设定“管理员角色”清单。一旦某个用户具备管理员角色，</br>
   * 那么该用户的功能请求访问将不再参与操作权验证
   */
  Set<String> onRequestIgnoreMethodCheckRoles();
}
