package com.bizunited.platform.security.sdk.event;

import java.util.Set;

/**
 * spring security被nebula封装以后，需要向上层模块暴露相关的事件监听。这里事件一般为要求上层用户模块进行订阅的事件</br>
 * @author yinwenjie
 */
public interface AuthenticationUserEventListener {
  /**
   * 当本次登录鉴权过程中，nebula-security组件需要获取当前登陆者所具备的角色（roleCode）时，该事件被触发
   * @param tenantCode 当前登录者的二级租户信息
   * @param account 当前登录者的账号信息。注意，有的时候登录并不是依靠account信息完成的。</br>
   * 这时需要在具体的AuthenticationDecision实现者中，完成LoginDetails对象的完善。
   * @return 返回的角色业务编号信息，将用于鉴权工作后续的功能
   */
  Set<String> onRequestRoleCodes(String tenantCode , String account);
}