package com.bizunited.platform.security.sdk.event;

/**
 * 鉴权决策器类型定义，目前支持六种</br>
 * 1、典型的账户名+密码方式；</br>
 * 2、典型的账户名 + 密码 + 校验码方式；</br>
 * 3、用户名 + 短信验证码 + 校验码方式；</br>
 * 4、手机号 + 密码方式；</br>
 * 5、手机号 + 短信验证码；</br>
 * 6、手机号 + 短信验证码 + 校验码方式</br>
 * 7、业务系统自定的其它登录方式
 * @author yinwenjie
 */
public enum DecisionTypes {
  // 典型的账户名+密码方式
  ACCOUNTANDPASSWORD(1),
  // 典型的账户名 + 密码 + 校验码方式
  ACCOUNTANDPASSWORDANDCCODE(2),
  // 用户名 + 短信验证码 + 校验码方式
  ACCOUNTANDCODE(3),
  // 手机号 + 密码方式
  PHONEANDPASSWORD(4),
  // 手机号 + 短信验证码
  PHONEANDSMSCODE(5),
  // 手机号 + 短信验证码 + 校验码方式
  PHONEANDCODE(6),
  // 业务系统自定的其它登录方式
  OTHER(7);
  
  private Integer code;

  DecisionTypes(Integer code) {
    this.code = code;
  }

  public Integer getCode() {
    return this.code;
  }
  
}
